/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.openxr.XrVector4f;
import org.lwjgl.openxr.XrVector4sFB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackingMeshFB
extends Struct<XrHandTrackingMeshFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int JOINTCAPACITYINPUT;
    public static final int JOINTCOUNTOUTPUT;
    public static final int JOINTBINDPOSES;
    public static final int JOINTRADII;
    public static final int JOINTPARENTS;
    public static final int VERTEXCAPACITYINPUT;
    public static final int VERTEXCOUNTOUTPUT;
    public static final int VERTEXPOSITIONS;
    public static final int VERTEXNORMALS;
    public static final int VERTEXUVS;
    public static final int VERTEXBLENDINDICES;
    public static final int VERTEXBLENDWEIGHTS;
    public static final int INDEXCAPACITYINPUT;
    public static final int INDEXCOUNTOUTPUT;
    public static final int INDICES;

    protected XrHandTrackingMeshFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHandTrackingMeshFB create(long address, @Nullable ByteBuffer container) {
        return new XrHandTrackingMeshFB(address, container);
    }

    public XrHandTrackingMeshFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandTrackingMeshFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackingMeshFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandTrackingMeshFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointCapacityInput() {
        return XrHandTrackingMeshFB.njointCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointCountOutput() {
        return XrHandTrackingMeshFB.njointCountOutput(this.address());
    }

    @NativeType(value="XrPosef *")
    public @Nullable XrPosef.Buffer jointBindPoses() {
        return XrHandTrackingMeshFB.njointBindPoses(this.address());
    }

    @NativeType(value="float *")
    public @Nullable FloatBuffer jointRadii() {
        return XrHandTrackingMeshFB.njointRadii(this.address());
    }

    @NativeType(value="XrHandJointEXT *")
    public @Nullable IntBuffer jointParents() {
        return XrHandTrackingMeshFB.njointParents(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCapacityInput() {
        return XrHandTrackingMeshFB.nvertexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCountOutput() {
        return XrHandTrackingMeshFB.nvertexCountOutput(this.address());
    }

    @NativeType(value="XrVector3f *")
    public @Nullable XrVector3f.Buffer vertexPositions() {
        return XrHandTrackingMeshFB.nvertexPositions(this.address());
    }

    @NativeType(value="XrVector3f *")
    public @Nullable XrVector3f.Buffer vertexNormals() {
        return XrHandTrackingMeshFB.nvertexNormals(this.address());
    }

    @NativeType(value="XrVector2f *")
    public @Nullable XrVector2f.Buffer vertexUVs() {
        return XrHandTrackingMeshFB.nvertexUVs(this.address());
    }

    @NativeType(value="XrVector4sFB *")
    public @Nullable XrVector4sFB.Buffer vertexBlendIndices() {
        return XrHandTrackingMeshFB.nvertexBlendIndices(this.address());
    }

    @NativeType(value="XrVector4f *")
    public @Nullable XrVector4f.Buffer vertexBlendWeights() {
        return XrHandTrackingMeshFB.nvertexBlendWeights(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCapacityInput() {
        return XrHandTrackingMeshFB.nindexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCountOutput() {
        return XrHandTrackingMeshFB.nindexCountOutput(this.address());
    }

    @NativeType(value="int16_t *")
    public @Nullable ShortBuffer indices() {
        return XrHandTrackingMeshFB.nindices(this.address());
    }

    public XrHandTrackingMeshFB type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackingMeshFB.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB type$Default() {
        return this.type(1000110001);
    }

    public XrHandTrackingMeshFB next(@NativeType(value="void *") long value) {
        XrHandTrackingMeshFB.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointCapacityInput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.njointCapacityInput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.njointCountOutput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointBindPoses(@NativeType(value="XrPosef *") @Nullable XrPosef.Buffer value) {
        XrHandTrackingMeshFB.njointBindPoses(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointRadii(@NativeType(value="float *") @Nullable FloatBuffer value) {
        XrHandTrackingMeshFB.njointRadii(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointParents(@NativeType(value="XrHandJointEXT *") @Nullable IntBuffer value) {
        XrHandTrackingMeshFB.njointParents(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexCapacityInput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.nvertexCapacityInput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.nvertexCountOutput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexPositions(@NativeType(value="XrVector3f *") @Nullable XrVector3f.Buffer value) {
        XrHandTrackingMeshFB.nvertexPositions(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexNormals(@NativeType(value="XrVector3f *") @Nullable XrVector3f.Buffer value) {
        XrHandTrackingMeshFB.nvertexNormals(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexUVs(@NativeType(value="XrVector2f *") @Nullable XrVector2f.Buffer value) {
        XrHandTrackingMeshFB.nvertexUVs(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexBlendIndices(@NativeType(value="XrVector4sFB *") @Nullable XrVector4sFB.Buffer value) {
        XrHandTrackingMeshFB.nvertexBlendIndices(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexBlendWeights(@NativeType(value="XrVector4f *") @Nullable XrVector4f.Buffer value) {
        XrHandTrackingMeshFB.nvertexBlendWeights(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB indexCapacityInput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.nindexCapacityInput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB indexCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.nindexCountOutput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB indices(@NativeType(value="int16_t *") @Nullable ShortBuffer value) {
        XrHandTrackingMeshFB.nindices(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB set(int type, long next, int jointCapacityInput, int jointCountOutput, @Nullable XrPosef.Buffer jointBindPoses, @Nullable FloatBuffer jointRadii, @Nullable IntBuffer jointParents, int vertexCapacityInput, int vertexCountOutput, @Nullable XrVector3f.Buffer vertexPositions, @Nullable XrVector3f.Buffer vertexNormals, @Nullable XrVector2f.Buffer vertexUVs, @Nullable XrVector4sFB.Buffer vertexBlendIndices, @Nullable XrVector4f.Buffer vertexBlendWeights, int indexCapacityInput, int indexCountOutput, @Nullable ShortBuffer indices) {
        this.type(type);
        this.next(next);
        this.jointCapacityInput(jointCapacityInput);
        this.jointCountOutput(jointCountOutput);
        this.jointBindPoses(jointBindPoses);
        this.jointRadii(jointRadii);
        this.jointParents(jointParents);
        this.vertexCapacityInput(vertexCapacityInput);
        this.vertexCountOutput(vertexCountOutput);
        this.vertexPositions(vertexPositions);
        this.vertexNormals(vertexNormals);
        this.vertexUVs(vertexUVs);
        this.vertexBlendIndices(vertexBlendIndices);
        this.vertexBlendWeights(vertexBlendWeights);
        this.indexCapacityInput(indexCapacityInput);
        this.indexCountOutput(indexCountOutput);
        this.indices(indices);
        return this;
    }

    public XrHandTrackingMeshFB set(XrHandTrackingMeshFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandTrackingMeshFB malloc() {
        return new XrHandTrackingMeshFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHandTrackingMeshFB calloc() {
        return new XrHandTrackingMeshFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHandTrackingMeshFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHandTrackingMeshFB(MemoryUtil.memAddress(container), container);
    }

    public static XrHandTrackingMeshFB create(long address) {
        return new XrHandTrackingMeshFB(address, null);
    }

    public static @Nullable XrHandTrackingMeshFB createSafe(long address) {
        return address == 0L ? null : new XrHandTrackingMeshFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHandTrackingMeshFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackingMeshFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandTrackingMeshFB malloc(MemoryStack stack) {
        return new XrHandTrackingMeshFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandTrackingMeshFB calloc(MemoryStack stack) {
        return new XrHandTrackingMeshFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int njointCapacityInput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)JOINTCAPACITYINPUT);
    }

    public static int njointCountOutput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)JOINTCOUNTOUTPUT);
    }

    public static @Nullable XrPosef.Buffer njointBindPoses(long struct) {
        return XrPosef.createSafe(MemoryUtil.memGetAddress(struct + (long)JOINTBINDPOSES), XrHandTrackingMeshFB.njointCapacityInput(struct));
    }

    public static @Nullable FloatBuffer njointRadii(long struct) {
        return MemoryUtil.memFloatBufferSafe(MemoryUtil.memGetAddress(struct + (long)JOINTRADII), XrHandTrackingMeshFB.njointCapacityInput(struct));
    }

    public static @Nullable IntBuffer njointParents(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)JOINTPARENTS), XrHandTrackingMeshFB.njointCapacityInput(struct));
    }

    public static int nvertexCapacityInput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXCAPACITYINPUT);
    }

    public static int nvertexCountOutput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXCOUNTOUTPUT);
    }

    public static @Nullable XrVector3f.Buffer nvertexPositions(long struct) {
        return XrVector3f.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTEXPOSITIONS), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static @Nullable XrVector3f.Buffer nvertexNormals(long struct) {
        return XrVector3f.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTEXNORMALS), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static @Nullable XrVector2f.Buffer nvertexUVs(long struct) {
        return XrVector2f.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTEXUVS), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static @Nullable XrVector4sFB.Buffer nvertexBlendIndices(long struct) {
        return XrVector4sFB.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTEXBLENDINDICES), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static @Nullable XrVector4f.Buffer nvertexBlendWeights(long struct) {
        return XrVector4f.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTEXBLENDWEIGHTS), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static int nindexCapacityInput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEXCAPACITYINPUT);
    }

    public static int nindexCountOutput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEXCOUNTOUTPUT);
    }

    public static @Nullable ShortBuffer nindices(long struct) {
        return MemoryUtil.memShortBufferSafe(MemoryUtil.memGetAddress(struct + (long)INDICES), XrHandTrackingMeshFB.nindexCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void njointCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)JOINTCAPACITYINPUT, value);
    }

    public static void njointCountOutput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)JOINTCOUNTOUTPUT, value);
    }

    public static void njointBindPoses(long struct, @Nullable XrPosef.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTBINDPOSES, MemoryUtil.memAddressSafe(value));
    }

    public static void njointRadii(long struct, @Nullable FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTRADII, MemoryUtil.memAddressSafe(value));
    }

    public static void njointParents(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTPARENTS, MemoryUtil.memAddressSafe(value));
    }

    public static void nvertexCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXCAPACITYINPUT, value);
    }

    public static void nvertexCountOutput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXCOUNTOUTPUT, value);
    }

    public static void nvertexPositions(long struct, @Nullable XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXPOSITIONS, MemoryUtil.memAddressSafe(value));
    }

    public static void nvertexNormals(long struct, @Nullable XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXNORMALS, MemoryUtil.memAddressSafe(value));
    }

    public static void nvertexUVs(long struct, @Nullable XrVector2f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXUVS, MemoryUtil.memAddressSafe(value));
    }

    public static void nvertexBlendIndices(long struct, @Nullable XrVector4sFB.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXBLENDINDICES, MemoryUtil.memAddressSafe(value));
    }

    public static void nvertexBlendWeights(long struct, @Nullable XrVector4f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXBLENDWEIGHTS, MemoryUtil.memAddressSafe(value));
    }

    public static void nindexCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDEXCAPACITYINPUT, value);
    }

    public static void nindexCountOutput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDEXCOUNTOUTPUT, value);
    }

    public static void nindices(long struct, @Nullable ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDICES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrHandTrackingMeshFB.nindexCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrHandTrackingMeshFB.__struct(XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        JOINTCAPACITYINPUT = layout.offsetof(2);
        JOINTCOUNTOUTPUT = layout.offsetof(3);
        JOINTBINDPOSES = layout.offsetof(4);
        JOINTRADII = layout.offsetof(5);
        JOINTPARENTS = layout.offsetof(6);
        VERTEXCAPACITYINPUT = layout.offsetof(7);
        VERTEXCOUNTOUTPUT = layout.offsetof(8);
        VERTEXPOSITIONS = layout.offsetof(9);
        VERTEXNORMALS = layout.offsetof(10);
        VERTEXUVS = layout.offsetof(11);
        VERTEXBLENDINDICES = layout.offsetof(12);
        VERTEXBLENDWEIGHTS = layout.offsetof(13);
        INDEXCAPACITYINPUT = layout.offsetof(14);
        INDEXCOUNTOUTPUT = layout.offsetof(15);
        INDICES = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackingMeshFB, Buffer>
    implements NativeResource {
        private static final XrHandTrackingMeshFB ELEMENT_FACTORY = XrHandTrackingMeshFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHandTrackingMeshFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackingMeshFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandTrackingMeshFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointCapacityInput() {
            return XrHandTrackingMeshFB.njointCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointCountOutput() {
            return XrHandTrackingMeshFB.njointCountOutput(this.address());
        }

        @NativeType(value="XrPosef *")
        public @Nullable XrPosef.Buffer jointBindPoses() {
            return XrHandTrackingMeshFB.njointBindPoses(this.address());
        }

        @NativeType(value="float *")
        public @Nullable FloatBuffer jointRadii() {
            return XrHandTrackingMeshFB.njointRadii(this.address());
        }

        @NativeType(value="XrHandJointEXT *")
        public @Nullable IntBuffer jointParents() {
            return XrHandTrackingMeshFB.njointParents(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCapacityInput() {
            return XrHandTrackingMeshFB.nvertexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCountOutput() {
            return XrHandTrackingMeshFB.nvertexCountOutput(this.address());
        }

        @NativeType(value="XrVector3f *")
        public @Nullable XrVector3f.Buffer vertexPositions() {
            return XrHandTrackingMeshFB.nvertexPositions(this.address());
        }

        @NativeType(value="XrVector3f *")
        public @Nullable XrVector3f.Buffer vertexNormals() {
            return XrHandTrackingMeshFB.nvertexNormals(this.address());
        }

        @NativeType(value="XrVector2f *")
        public @Nullable XrVector2f.Buffer vertexUVs() {
            return XrHandTrackingMeshFB.nvertexUVs(this.address());
        }

        @NativeType(value="XrVector4sFB *")
        public @Nullable XrVector4sFB.Buffer vertexBlendIndices() {
            return XrHandTrackingMeshFB.nvertexBlendIndices(this.address());
        }

        @NativeType(value="XrVector4f *")
        public @Nullable XrVector4f.Buffer vertexBlendWeights() {
            return XrHandTrackingMeshFB.nvertexBlendWeights(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCapacityInput() {
            return XrHandTrackingMeshFB.nindexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCountOutput() {
            return XrHandTrackingMeshFB.nindexCountOutput(this.address());
        }

        @NativeType(value="int16_t *")
        public @Nullable ShortBuffer indices() {
            return XrHandTrackingMeshFB.nindices(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackingMeshFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000110001);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandTrackingMeshFB.nnext(this.address(), value);
            return this;
        }

        public Buffer jointCapacityInput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.njointCapacityInput(this.address(), value);
            return this;
        }

        public Buffer jointCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.njointCountOutput(this.address(), value);
            return this;
        }

        public Buffer jointBindPoses(@NativeType(value="XrPosef *") @Nullable XrPosef.Buffer value) {
            XrHandTrackingMeshFB.njointBindPoses(this.address(), value);
            return this;
        }

        public Buffer jointRadii(@NativeType(value="float *") @Nullable FloatBuffer value) {
            XrHandTrackingMeshFB.njointRadii(this.address(), value);
            return this;
        }

        public Buffer jointParents(@NativeType(value="XrHandJointEXT *") @Nullable IntBuffer value) {
            XrHandTrackingMeshFB.njointParents(this.address(), value);
            return this;
        }

        public Buffer vertexCapacityInput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.nvertexCapacityInput(this.address(), value);
            return this;
        }

        public Buffer vertexCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.nvertexCountOutput(this.address(), value);
            return this;
        }

        public Buffer vertexPositions(@NativeType(value="XrVector3f *") @Nullable XrVector3f.Buffer value) {
            XrHandTrackingMeshFB.nvertexPositions(this.address(), value);
            return this;
        }

        public Buffer vertexNormals(@NativeType(value="XrVector3f *") @Nullable XrVector3f.Buffer value) {
            XrHandTrackingMeshFB.nvertexNormals(this.address(), value);
            return this;
        }

        public Buffer vertexUVs(@NativeType(value="XrVector2f *") @Nullable XrVector2f.Buffer value) {
            XrHandTrackingMeshFB.nvertexUVs(this.address(), value);
            return this;
        }

        public Buffer vertexBlendIndices(@NativeType(value="XrVector4sFB *") @Nullable XrVector4sFB.Buffer value) {
            XrHandTrackingMeshFB.nvertexBlendIndices(this.address(), value);
            return this;
        }

        public Buffer vertexBlendWeights(@NativeType(value="XrVector4f *") @Nullable XrVector4f.Buffer value) {
            XrHandTrackingMeshFB.nvertexBlendWeights(this.address(), value);
            return this;
        }

        public Buffer indexCapacityInput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.nindexCapacityInput(this.address(), value);
            return this;
        }

        public Buffer indexCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.nindexCountOutput(this.address(), value);
            return this;
        }

        public Buffer indices(@NativeType(value="int16_t *") @Nullable ShortBuffer value) {
            XrHandTrackingMeshFB.nindices(this.address(), value);
            return this;
        }
    }
}

