/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackingScaleFB
extends Struct<XrHandTrackingScaleFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SENSOROUTPUT;
    public static final int CURRENTOUTPUT;
    public static final int OVERRIDEHANDSCALE;
    public static final int OVERRIDEVALUEINPUT;

    protected XrHandTrackingScaleFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHandTrackingScaleFB create(long address, @Nullable ByteBuffer container) {
        return new XrHandTrackingScaleFB(address, container);
    }

    public XrHandTrackingScaleFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandTrackingScaleFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackingScaleFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandTrackingScaleFB.nnext(this.address());
    }

    public float sensorOutput() {
        return XrHandTrackingScaleFB.nsensorOutput(this.address());
    }

    public float currentOutput() {
        return XrHandTrackingScaleFB.ncurrentOutput(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean overrideHandScale() {
        return XrHandTrackingScaleFB.noverrideHandScale(this.address()) != 0;
    }

    public float overrideValueInput() {
        return XrHandTrackingScaleFB.noverrideValueInput(this.address());
    }

    public XrHandTrackingScaleFB type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackingScaleFB.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackingScaleFB type$Default() {
        return this.type(1000110003);
    }

    public XrHandTrackingScaleFB next(@NativeType(value="void *") long value) {
        XrHandTrackingScaleFB.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackingScaleFB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrHandTrackingScaleFB set(XrHandTrackingScaleFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandTrackingScaleFB malloc() {
        return new XrHandTrackingScaleFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHandTrackingScaleFB calloc() {
        return new XrHandTrackingScaleFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHandTrackingScaleFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHandTrackingScaleFB(MemoryUtil.memAddress(container), container);
    }

    public static XrHandTrackingScaleFB create(long address) {
        return new XrHandTrackingScaleFB(address, null);
    }

    public static @Nullable XrHandTrackingScaleFB createSafe(long address) {
        return address == 0L ? null : new XrHandTrackingScaleFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHandTrackingScaleFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackingScaleFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandTrackingScaleFB malloc(MemoryStack stack) {
        return new XrHandTrackingScaleFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandTrackingScaleFB calloc(MemoryStack stack) {
        return new XrHandTrackingScaleFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static float nsensorOutput(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)SENSOROUTPUT);
    }

    public static float ncurrentOutput(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CURRENTOUTPUT);
    }

    public static int noverrideHandScale(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OVERRIDEHANDSCALE);
    }

    public static float noverrideValueInput(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)OVERRIDEVALUEINPUT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrHandTrackingScaleFB.__struct(XrHandTrackingScaleFB.__member(4), XrHandTrackingScaleFB.__member(POINTER_SIZE), XrHandTrackingScaleFB.__member(4), XrHandTrackingScaleFB.__member(4), XrHandTrackingScaleFB.__member(4), XrHandTrackingScaleFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SENSOROUTPUT = layout.offsetof(2);
        CURRENTOUTPUT = layout.offsetof(3);
        OVERRIDEHANDSCALE = layout.offsetof(4);
        OVERRIDEVALUEINPUT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackingScaleFB, Buffer>
    implements NativeResource {
        private static final XrHandTrackingScaleFB ELEMENT_FACTORY = XrHandTrackingScaleFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHandTrackingScaleFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackingScaleFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandTrackingScaleFB.nnext(this.address());
        }

        public float sensorOutput() {
            return XrHandTrackingScaleFB.nsensorOutput(this.address());
        }

        public float currentOutput() {
            return XrHandTrackingScaleFB.ncurrentOutput(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean overrideHandScale() {
            return XrHandTrackingScaleFB.noverrideHandScale(this.address()) != 0;
        }

        public float overrideValueInput() {
            return XrHandTrackingScaleFB.noverrideValueInput(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackingScaleFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000110003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandTrackingScaleFB.nnext(this.address(), value);
            return this;
        }
    }
}

