/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHapticBaseHeader;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHapticVibration
extends Struct<XrHapticVibration>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int DURATION;
    public static final int FREQUENCY;
    public static final int AMPLITUDE;

    protected XrHapticVibration(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHapticVibration create(long address, @Nullable ByteBuffer container) {
        return new XrHapticVibration(address, container);
    }

    public XrHapticVibration(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHapticVibration.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHapticVibration.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHapticVibration.nnext(this.address());
    }

    @NativeType(value="XrDuration")
    public long duration() {
        return XrHapticVibration.nduration(this.address());
    }

    public float frequency() {
        return XrHapticVibration.nfrequency(this.address());
    }

    public float amplitude() {
        return XrHapticVibration.namplitude(this.address());
    }

    public XrHapticVibration type(@NativeType(value="XrStructureType") int value) {
        XrHapticVibration.ntype(this.address(), value);
        return this;
    }

    public XrHapticVibration type$Default() {
        return this.type(13);
    }

    public XrHapticVibration next(@NativeType(value="void const *") long value) {
        XrHapticVibration.nnext(this.address(), value);
        return this;
    }

    public XrHapticVibration duration(@NativeType(value="XrDuration") long value) {
        XrHapticVibration.nduration(this.address(), value);
        return this;
    }

    public XrHapticVibration frequency(float value) {
        XrHapticVibration.nfrequency(this.address(), value);
        return this;
    }

    public XrHapticVibration amplitude(float value) {
        XrHapticVibration.namplitude(this.address(), value);
        return this;
    }

    public XrHapticVibration set(int type, long next, long duration, float frequency, float amplitude) {
        this.type(type);
        this.next(next);
        this.duration(duration);
        this.frequency(frequency);
        this.amplitude(amplitude);
        return this;
    }

    public XrHapticVibration set(XrHapticVibration src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHapticVibration malloc() {
        return new XrHapticVibration(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHapticVibration calloc() {
        return new XrHapticVibration(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHapticVibration create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHapticVibration(MemoryUtil.memAddress(container), container);
    }

    public static XrHapticVibration create(long address) {
        return new XrHapticVibration(address, null);
    }

    public static @Nullable XrHapticVibration createSafe(long address) {
        return address == 0L ? null : new XrHapticVibration(address, null);
    }

    public static XrHapticVibration create(XrHapticBaseHeader value) {
        return new XrHapticVibration(value.address(), XrHapticVibration.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHapticVibration.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHapticVibration.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrHapticBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrHapticVibration.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrHapticVibration malloc(MemoryStack stack) {
        return new XrHapticVibration(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHapticVibration calloc(MemoryStack stack) {
        return new XrHapticVibration(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nduration(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DURATION);
    }

    public static float nfrequency(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FREQUENCY);
    }

    public static float namplitude(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)AMPLITUDE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nduration(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DURATION, value);
    }

    public static void nfrequency(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FREQUENCY, value);
    }

    public static void namplitude(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)AMPLITUDE, value);
    }

    static {
        Struct.Layout layout = XrHapticVibration.__struct(XrHapticVibration.__member(4), XrHapticVibration.__member(POINTER_SIZE), XrHapticVibration.__member(8), XrHapticVibration.__member(4), XrHapticVibration.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        DURATION = layout.offsetof(2);
        FREQUENCY = layout.offsetof(3);
        AMPLITUDE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrHapticVibration, Buffer>
    implements NativeResource {
        private static final XrHapticVibration ELEMENT_FACTORY = XrHapticVibration.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHapticVibration getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHapticVibration.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHapticVibration.nnext(this.address());
        }

        @NativeType(value="XrDuration")
        public long duration() {
            return XrHapticVibration.nduration(this.address());
        }

        public float frequency() {
            return XrHapticVibration.nfrequency(this.address());
        }

        public float amplitude() {
            return XrHapticVibration.namplitude(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHapticVibration.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(13);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHapticVibration.nnext(this.address(), value);
            return this;
        }

        public Buffer duration(@NativeType(value="XrDuration") long value) {
            XrHapticVibration.nduration(this.address(), value);
            return this;
        }

        public Buffer frequency(float value) {
            XrHapticVibration.nfrequency(this.address(), value);
            return this;
        }

        public Buffer amplitude(float value) {
            XrHapticVibration.namplitude(this.address(), value);
            return this;
        }
    }
}

