/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHolographicWindowAttachmentMSFT
extends Struct<XrHolographicWindowAttachmentMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int HOLOGRAPHICSPACE;
    public static final int COREWINDOW;

    protected XrHolographicWindowAttachmentMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHolographicWindowAttachmentMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrHolographicWindowAttachmentMSFT(address, container);
    }

    public XrHolographicWindowAttachmentMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHolographicWindowAttachmentMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHolographicWindowAttachmentMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHolographicWindowAttachmentMSFT.nnext(this.address());
    }

    @NativeType(value="IUnknown *")
    public long holographicSpace() {
        return XrHolographicWindowAttachmentMSFT.nholographicSpace(this.address());
    }

    @NativeType(value="IUnknown *")
    public long coreWindow() {
        return XrHolographicWindowAttachmentMSFT.ncoreWindow(this.address());
    }

    public XrHolographicWindowAttachmentMSFT type(@NativeType(value="XrStructureType") int value) {
        XrHolographicWindowAttachmentMSFT.ntype(this.address(), value);
        return this;
    }

    public XrHolographicWindowAttachmentMSFT type$Default() {
        return this.type(1000063000);
    }

    public XrHolographicWindowAttachmentMSFT next(@NativeType(value="void const *") long value) {
        XrHolographicWindowAttachmentMSFT.nnext(this.address(), value);
        return this;
    }

    public XrHolographicWindowAttachmentMSFT holographicSpace(@NativeType(value="IUnknown *") long value) {
        XrHolographicWindowAttachmentMSFT.nholographicSpace(this.address(), value);
        return this;
    }

    public XrHolographicWindowAttachmentMSFT coreWindow(@NativeType(value="IUnknown *") long value) {
        XrHolographicWindowAttachmentMSFT.ncoreWindow(this.address(), value);
        return this;
    }

    public XrHolographicWindowAttachmentMSFT set(int type, long next, long holographicSpace, long coreWindow) {
        this.type(type);
        this.next(next);
        this.holographicSpace(holographicSpace);
        this.coreWindow(coreWindow);
        return this;
    }

    public XrHolographicWindowAttachmentMSFT set(XrHolographicWindowAttachmentMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHolographicWindowAttachmentMSFT malloc() {
        return new XrHolographicWindowAttachmentMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHolographicWindowAttachmentMSFT calloc() {
        return new XrHolographicWindowAttachmentMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHolographicWindowAttachmentMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHolographicWindowAttachmentMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrHolographicWindowAttachmentMSFT create(long address) {
        return new XrHolographicWindowAttachmentMSFT(address, null);
    }

    public static @Nullable XrHolographicWindowAttachmentMSFT createSafe(long address) {
        return address == 0L ? null : new XrHolographicWindowAttachmentMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHolographicWindowAttachmentMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHolographicWindowAttachmentMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHolographicWindowAttachmentMSFT malloc(MemoryStack stack) {
        return new XrHolographicWindowAttachmentMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHolographicWindowAttachmentMSFT calloc(MemoryStack stack) {
        return new XrHolographicWindowAttachmentMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nholographicSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HOLOGRAPHICSPACE);
    }

    public static long ncoreWindow(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)COREWINDOW);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nholographicSpace(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HOLOGRAPHICSPACE, Checks.check(value));
    }

    public static void ncoreWindow(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)COREWINDOW, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HOLOGRAPHICSPACE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)COREWINDOW));
    }

    static {
        Struct.Layout layout = XrHolographicWindowAttachmentMSFT.__struct(XrHolographicWindowAttachmentMSFT.__member(4), XrHolographicWindowAttachmentMSFT.__member(POINTER_SIZE), XrHolographicWindowAttachmentMSFT.__member(POINTER_SIZE), XrHolographicWindowAttachmentMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        HOLOGRAPHICSPACE = layout.offsetof(2);
        COREWINDOW = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHolographicWindowAttachmentMSFT, Buffer>
    implements NativeResource {
        private static final XrHolographicWindowAttachmentMSFT ELEMENT_FACTORY = XrHolographicWindowAttachmentMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHolographicWindowAttachmentMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHolographicWindowAttachmentMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHolographicWindowAttachmentMSFT.nnext(this.address());
        }

        @NativeType(value="IUnknown *")
        public long holographicSpace() {
            return XrHolographicWindowAttachmentMSFT.nholographicSpace(this.address());
        }

        @NativeType(value="IUnknown *")
        public long coreWindow() {
            return XrHolographicWindowAttachmentMSFT.ncoreWindow(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHolographicWindowAttachmentMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000063000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHolographicWindowAttachmentMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer holographicSpace(@NativeType(value="IUnknown *") long value) {
            XrHolographicWindowAttachmentMSFT.nholographicSpace(this.address(), value);
            return this;
        }

        public Buffer coreWindow(@NativeType(value="IUnknown *") long value) {
            XrHolographicWindowAttachmentMSFT.ncoreWindow(this.address(), value);
            return this;
        }
    }
}

