/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInputSourceLocalizedNameGetInfo
extends Struct<XrInputSourceLocalizedNameGetInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SOURCEPATH;
    public static final int WHICHCOMPONENTS;

    protected XrInputSourceLocalizedNameGetInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrInputSourceLocalizedNameGetInfo create(long address, @Nullable ByteBuffer container) {
        return new XrInputSourceLocalizedNameGetInfo(address, container);
    }

    public XrInputSourceLocalizedNameGetInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrInputSourceLocalizedNameGetInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInputSourceLocalizedNameGetInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrInputSourceLocalizedNameGetInfo.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long sourcePath() {
        return XrInputSourceLocalizedNameGetInfo.nsourcePath(this.address());
    }

    @NativeType(value="XrInputSourceLocalizedNameFlags")
    public long whichComponents() {
        return XrInputSourceLocalizedNameGetInfo.nwhichComponents(this.address());
    }

    public XrInputSourceLocalizedNameGetInfo type(@NativeType(value="XrStructureType") int value) {
        XrInputSourceLocalizedNameGetInfo.ntype(this.address(), value);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo type$Default() {
        return this.type(63);
    }

    public XrInputSourceLocalizedNameGetInfo next(@NativeType(value="void const *") long value) {
        XrInputSourceLocalizedNameGetInfo.nnext(this.address(), value);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo sourcePath(@NativeType(value="XrPath") long value) {
        XrInputSourceLocalizedNameGetInfo.nsourcePath(this.address(), value);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo whichComponents(@NativeType(value="XrInputSourceLocalizedNameFlags") long value) {
        XrInputSourceLocalizedNameGetInfo.nwhichComponents(this.address(), value);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo set(int type, long next, long sourcePath, long whichComponents) {
        this.type(type);
        this.next(next);
        this.sourcePath(sourcePath);
        this.whichComponents(whichComponents);
        return this;
    }

    public XrInputSourceLocalizedNameGetInfo set(XrInputSourceLocalizedNameGetInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrInputSourceLocalizedNameGetInfo malloc() {
        return new XrInputSourceLocalizedNameGetInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrInputSourceLocalizedNameGetInfo calloc() {
        return new XrInputSourceLocalizedNameGetInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrInputSourceLocalizedNameGetInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrInputSourceLocalizedNameGetInfo(MemoryUtil.memAddress(container), container);
    }

    public static XrInputSourceLocalizedNameGetInfo create(long address) {
        return new XrInputSourceLocalizedNameGetInfo(address, null);
    }

    public static @Nullable XrInputSourceLocalizedNameGetInfo createSafe(long address) {
        return address == 0L ? null : new XrInputSourceLocalizedNameGetInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrInputSourceLocalizedNameGetInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInputSourceLocalizedNameGetInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrInputSourceLocalizedNameGetInfo malloc(MemoryStack stack) {
        return new XrInputSourceLocalizedNameGetInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrInputSourceLocalizedNameGetInfo calloc(MemoryStack stack) {
        return new XrInputSourceLocalizedNameGetInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nsourcePath(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SOURCEPATH);
    }

    public static long nwhichComponents(long struct) {
        return MemoryUtil.memGetLong(struct + (long)WHICHCOMPONENTS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsourcePath(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SOURCEPATH, value);
    }

    public static void nwhichComponents(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)WHICHCOMPONENTS, value);
    }

    static {
        Struct.Layout layout = XrInputSourceLocalizedNameGetInfo.__struct(XrInputSourceLocalizedNameGetInfo.__member(4), XrInputSourceLocalizedNameGetInfo.__member(POINTER_SIZE), XrInputSourceLocalizedNameGetInfo.__member(8), XrInputSourceLocalizedNameGetInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SOURCEPATH = layout.offsetof(2);
        WHICHCOMPONENTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrInputSourceLocalizedNameGetInfo, Buffer>
    implements NativeResource {
        private static final XrInputSourceLocalizedNameGetInfo ELEMENT_FACTORY = XrInputSourceLocalizedNameGetInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrInputSourceLocalizedNameGetInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInputSourceLocalizedNameGetInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrInputSourceLocalizedNameGetInfo.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long sourcePath() {
            return XrInputSourceLocalizedNameGetInfo.nsourcePath(this.address());
        }

        @NativeType(value="XrInputSourceLocalizedNameFlags")
        public long whichComponents() {
            return XrInputSourceLocalizedNameGetInfo.nwhichComponents(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInputSourceLocalizedNameGetInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(63);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrInputSourceLocalizedNameGetInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer sourcePath(@NativeType(value="XrPath") long value) {
            XrInputSourceLocalizedNameGetInfo.nsourcePath(this.address(), value);
            return this;
        }

        public Buffer whichComponents(@NativeType(value="XrInputSourceLocalizedNameFlags") long value) {
            XrInputSourceLocalizedNameGetInfo.nwhichComponents(this.address(), value);
            return this;
        }
    }
}

