/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInstanceProperties
extends Struct<XrInstanceProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int RUNTIMEVERSION;
    public static final int RUNTIMENAME;

    protected XrInstanceProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrInstanceProperties create(long address, @Nullable ByteBuffer container) {
        return new XrInstanceProperties(address, container);
    }

    public XrInstanceProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrInstanceProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInstanceProperties.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrInstanceProperties.nnext(this.address());
    }

    @NativeType(value="XrVersion")
    public long runtimeVersion() {
        return XrInstanceProperties.nruntimeVersion(this.address());
    }

    @NativeType(value="char[XR_MAX_RUNTIME_NAME_SIZE]")
    public ByteBuffer runtimeName() {
        return XrInstanceProperties.nruntimeName(this.address());
    }

    @NativeType(value="char[XR_MAX_RUNTIME_NAME_SIZE]")
    public String runtimeNameString() {
        return XrInstanceProperties.nruntimeNameString(this.address());
    }

    public XrInstanceProperties type(@NativeType(value="XrStructureType") int value) {
        XrInstanceProperties.ntype(this.address(), value);
        return this;
    }

    public XrInstanceProperties type$Default() {
        return this.type(32);
    }

    public XrInstanceProperties next(@NativeType(value="void *") long value) {
        XrInstanceProperties.nnext(this.address(), value);
        return this;
    }

    public XrInstanceProperties set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrInstanceProperties set(XrInstanceProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrInstanceProperties malloc() {
        return new XrInstanceProperties(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrInstanceProperties calloc() {
        return new XrInstanceProperties(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrInstanceProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrInstanceProperties(MemoryUtil.memAddress(container), container);
    }

    public static XrInstanceProperties create(long address) {
        return new XrInstanceProperties(address, null);
    }

    public static @Nullable XrInstanceProperties createSafe(long address) {
        return address == 0L ? null : new XrInstanceProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrInstanceProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInstanceProperties.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrInstanceProperties malloc(MemoryStack stack) {
        return new XrInstanceProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrInstanceProperties calloc(MemoryStack stack) {
        return new XrInstanceProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nruntimeVersion(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RUNTIMEVERSION);
    }

    public static ByteBuffer nruntimeName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RUNTIMENAME, 128);
    }

    public static String nruntimeNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)RUNTIMENAME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrInstanceProperties.__struct(XrInstanceProperties.__member(4), XrInstanceProperties.__member(POINTER_SIZE), XrInstanceProperties.__member(8), XrInstanceProperties.__array(1, 128));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        RUNTIMEVERSION = layout.offsetof(2);
        RUNTIMENAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrInstanceProperties, Buffer>
    implements NativeResource {
        private static final XrInstanceProperties ELEMENT_FACTORY = XrInstanceProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrInstanceProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInstanceProperties.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrInstanceProperties.nnext(this.address());
        }

        @NativeType(value="XrVersion")
        public long runtimeVersion() {
            return XrInstanceProperties.nruntimeVersion(this.address());
        }

        @NativeType(value="char[XR_MAX_RUNTIME_NAME_SIZE]")
        public ByteBuffer runtimeName() {
            return XrInstanceProperties.nruntimeName(this.address());
        }

        @NativeType(value="char[XR_MAX_RUNTIME_NAME_SIZE]")
        public String runtimeNameString() {
            return XrInstanceProperties.nruntimeNameString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInstanceProperties.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(32);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrInstanceProperties.nnext(this.address(), value);
            return this;
        }
    }
}

