/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerDetectorArucoInfoML
extends Struct<XrMarkerDetectorArucoInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ARUCODICT;

    protected XrMarkerDetectorArucoInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrMarkerDetectorArucoInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerDetectorArucoInfoML(address, container);
    }

    public XrMarkerDetectorArucoInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrMarkerDetectorArucoInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerDetectorArucoInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerDetectorArucoInfoML.nnext(this.address());
    }

    @NativeType(value="XrMarkerArucoDictML")
    public int arucoDict() {
        return XrMarkerDetectorArucoInfoML.narucoDict(this.address());
    }

    public XrMarkerDetectorArucoInfoML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerDetectorArucoInfoML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerDetectorArucoInfoML type$Default() {
        return this.type(1000138002);
    }

    public XrMarkerDetectorArucoInfoML next(@NativeType(value="void const *") long value) {
        XrMarkerDetectorArucoInfoML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerDetectorArucoInfoML arucoDict(@NativeType(value="XrMarkerArucoDictML") int value) {
        XrMarkerDetectorArucoInfoML.narucoDict(this.address(), value);
        return this;
    }

    public XrMarkerDetectorArucoInfoML set(int type, long next, int arucoDict) {
        this.type(type);
        this.next(next);
        this.arucoDict(arucoDict);
        return this;
    }

    public XrMarkerDetectorArucoInfoML set(XrMarkerDetectorArucoInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrMarkerDetectorArucoInfoML malloc() {
        return new XrMarkerDetectorArucoInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrMarkerDetectorArucoInfoML calloc() {
        return new XrMarkerDetectorArucoInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrMarkerDetectorArucoInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrMarkerDetectorArucoInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrMarkerDetectorArucoInfoML create(long address) {
        return new XrMarkerDetectorArucoInfoML(address, null);
    }

    public static @Nullable XrMarkerDetectorArucoInfoML createSafe(long address) {
        return address == 0L ? null : new XrMarkerDetectorArucoInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrMarkerDetectorArucoInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerDetectorArucoInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerDetectorArucoInfoML malloc(MemoryStack stack) {
        return new XrMarkerDetectorArucoInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerDetectorArucoInfoML calloc(MemoryStack stack) {
        return new XrMarkerDetectorArucoInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int narucoDict(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ARUCODICT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void narucoDict(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ARUCODICT, value);
    }

    static {
        Struct.Layout layout = XrMarkerDetectorArucoInfoML.__struct(XrMarkerDetectorArucoInfoML.__member(4), XrMarkerDetectorArucoInfoML.__member(POINTER_SIZE), XrMarkerDetectorArucoInfoML.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ARUCODICT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerDetectorArucoInfoML, Buffer>
    implements NativeResource {
        private static final XrMarkerDetectorArucoInfoML ELEMENT_FACTORY = XrMarkerDetectorArucoInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrMarkerDetectorArucoInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerDetectorArucoInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerDetectorArucoInfoML.nnext(this.address());
        }

        @NativeType(value="XrMarkerArucoDictML")
        public int arucoDict() {
            return XrMarkerDetectorArucoInfoML.narucoDict(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerDetectorArucoInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerDetectorArucoInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer arucoDict(@NativeType(value="XrMarkerArucoDictML") int value) {
            XrMarkerDetectorArucoInfoML.narucoDict(this.address(), value);
            return this;
        }
    }
}

