/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerDetectorSizeInfoML
extends Struct<XrMarkerDetectorSizeInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MARKERLENGTH;

    protected XrMarkerDetectorSizeInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrMarkerDetectorSizeInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerDetectorSizeInfoML(address, container);
    }

    public XrMarkerDetectorSizeInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrMarkerDetectorSizeInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerDetectorSizeInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerDetectorSizeInfoML.nnext(this.address());
    }

    public float markerLength() {
        return XrMarkerDetectorSizeInfoML.nmarkerLength(this.address());
    }

    public XrMarkerDetectorSizeInfoML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerDetectorSizeInfoML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerDetectorSizeInfoML type$Default() {
        return this.type(1000138003);
    }

    public XrMarkerDetectorSizeInfoML next(@NativeType(value="void const *") long value) {
        XrMarkerDetectorSizeInfoML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerDetectorSizeInfoML markerLength(float value) {
        XrMarkerDetectorSizeInfoML.nmarkerLength(this.address(), value);
        return this;
    }

    public XrMarkerDetectorSizeInfoML set(int type, long next, float markerLength) {
        this.type(type);
        this.next(next);
        this.markerLength(markerLength);
        return this;
    }

    public XrMarkerDetectorSizeInfoML set(XrMarkerDetectorSizeInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrMarkerDetectorSizeInfoML malloc() {
        return new XrMarkerDetectorSizeInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrMarkerDetectorSizeInfoML calloc() {
        return new XrMarkerDetectorSizeInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrMarkerDetectorSizeInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrMarkerDetectorSizeInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrMarkerDetectorSizeInfoML create(long address) {
        return new XrMarkerDetectorSizeInfoML(address, null);
    }

    public static @Nullable XrMarkerDetectorSizeInfoML createSafe(long address) {
        return address == 0L ? null : new XrMarkerDetectorSizeInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrMarkerDetectorSizeInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerDetectorSizeInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerDetectorSizeInfoML malloc(MemoryStack stack) {
        return new XrMarkerDetectorSizeInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerDetectorSizeInfoML calloc(MemoryStack stack) {
        return new XrMarkerDetectorSizeInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static float nmarkerLength(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MARKERLENGTH);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nmarkerLength(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MARKERLENGTH, value);
    }

    static {
        Struct.Layout layout = XrMarkerDetectorSizeInfoML.__struct(XrMarkerDetectorSizeInfoML.__member(4), XrMarkerDetectorSizeInfoML.__member(POINTER_SIZE), XrMarkerDetectorSizeInfoML.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MARKERLENGTH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerDetectorSizeInfoML, Buffer>
    implements NativeResource {
        private static final XrMarkerDetectorSizeInfoML ELEMENT_FACTORY = XrMarkerDetectorSizeInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrMarkerDetectorSizeInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerDetectorSizeInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerDetectorSizeInfoML.nnext(this.address());
        }

        public float markerLength() {
            return XrMarkerDetectorSizeInfoML.nmarkerLength(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerDetectorSizeInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerDetectorSizeInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer markerLength(float value) {
            XrMarkerDetectorSizeInfoML.nmarkerLength(this.address(), value);
            return this;
        }
    }
}

