/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerDetectorStateML
extends Struct<XrMarkerDetectorStateML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int STATE;

    protected XrMarkerDetectorStateML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrMarkerDetectorStateML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerDetectorStateML(address, container);
    }

    public XrMarkerDetectorStateML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrMarkerDetectorStateML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerDetectorStateML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrMarkerDetectorStateML.nnext(this.address());
    }

    @NativeType(value="XrMarkerDetectorStatusML")
    public int state() {
        return XrMarkerDetectorStateML.nstate(this.address());
    }

    public XrMarkerDetectorStateML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerDetectorStateML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerDetectorStateML type$Default() {
        return this.type(1000138007);
    }

    public XrMarkerDetectorStateML next(@NativeType(value="void *") long value) {
        XrMarkerDetectorStateML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerDetectorStateML set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrMarkerDetectorStateML set(XrMarkerDetectorStateML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrMarkerDetectorStateML malloc() {
        return new XrMarkerDetectorStateML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrMarkerDetectorStateML calloc() {
        return new XrMarkerDetectorStateML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrMarkerDetectorStateML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrMarkerDetectorStateML(MemoryUtil.memAddress(container), container);
    }

    public static XrMarkerDetectorStateML create(long address) {
        return new XrMarkerDetectorStateML(address, null);
    }

    public static @Nullable XrMarkerDetectorStateML createSafe(long address) {
        return address == 0L ? null : new XrMarkerDetectorStateML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrMarkerDetectorStateML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerDetectorStateML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerDetectorStateML malloc(MemoryStack stack) {
        return new XrMarkerDetectorStateML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerDetectorStateML calloc(MemoryStack stack) {
        return new XrMarkerDetectorStateML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nstate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STATE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrMarkerDetectorStateML.__struct(XrMarkerDetectorStateML.__member(4), XrMarkerDetectorStateML.__member(POINTER_SIZE), XrMarkerDetectorStateML.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        STATE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerDetectorStateML, Buffer>
    implements NativeResource {
        private static final XrMarkerDetectorStateML ELEMENT_FACTORY = XrMarkerDetectorStateML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrMarkerDetectorStateML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerDetectorStateML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrMarkerDetectorStateML.nnext(this.address());
        }

        @NativeType(value="XrMarkerDetectorStatusML")
        public int state() {
            return XrMarkerDetectorStateML.nstate(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerDetectorStateML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138007);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrMarkerDetectorStateML.nnext(this.address(), value);
            return this;
        }
    }
}

