/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrMarkerDetectorML;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerSpaceCreateInfoML
extends Struct<XrMarkerSpaceCreateInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MARKERDETECTOR;
    public static final int MARKER;
    public static final int POSEINMARKERSPACE;

    protected XrMarkerSpaceCreateInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrMarkerSpaceCreateInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerSpaceCreateInfoML(address, container);
    }

    public XrMarkerSpaceCreateInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrMarkerSpaceCreateInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerSpaceCreateInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerSpaceCreateInfoML.nnext(this.address());
    }

    @NativeType(value="XrMarkerDetectorML")
    public long markerDetector() {
        return XrMarkerSpaceCreateInfoML.nmarkerDetector(this.address());
    }

    @NativeType(value="XrMarkerML")
    public long marker() {
        return XrMarkerSpaceCreateInfoML.nmarker(this.address());
    }

    public XrPosef poseInMarkerSpace() {
        return XrMarkerSpaceCreateInfoML.nposeInMarkerSpace(this.address());
    }

    public XrMarkerSpaceCreateInfoML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerSpaceCreateInfoML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML type$Default() {
        return this.type(1000138008);
    }

    public XrMarkerSpaceCreateInfoML next(@NativeType(value="void const *") long value) {
        XrMarkerSpaceCreateInfoML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML markerDetector(XrMarkerDetectorML value) {
        XrMarkerSpaceCreateInfoML.nmarkerDetector(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML marker(@NativeType(value="XrMarkerML") long value) {
        XrMarkerSpaceCreateInfoML.nmarker(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML poseInMarkerSpace(XrPosef value) {
        XrMarkerSpaceCreateInfoML.nposeInMarkerSpace(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML poseInMarkerSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInMarkerSpace());
        return this;
    }

    public XrMarkerSpaceCreateInfoML set(int type, long next, XrMarkerDetectorML markerDetector, long marker, XrPosef poseInMarkerSpace) {
        this.type(type);
        this.next(next);
        this.markerDetector(markerDetector);
        this.marker(marker);
        this.poseInMarkerSpace(poseInMarkerSpace);
        return this;
    }

    public XrMarkerSpaceCreateInfoML set(XrMarkerSpaceCreateInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrMarkerSpaceCreateInfoML malloc() {
        return new XrMarkerSpaceCreateInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrMarkerSpaceCreateInfoML calloc() {
        return new XrMarkerSpaceCreateInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrMarkerSpaceCreateInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrMarkerSpaceCreateInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrMarkerSpaceCreateInfoML create(long address) {
        return new XrMarkerSpaceCreateInfoML(address, null);
    }

    public static @Nullable XrMarkerSpaceCreateInfoML createSafe(long address) {
        return address == 0L ? null : new XrMarkerSpaceCreateInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrMarkerSpaceCreateInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerSpaceCreateInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerSpaceCreateInfoML malloc(MemoryStack stack) {
        return new XrMarkerSpaceCreateInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerSpaceCreateInfoML calloc(MemoryStack stack) {
        return new XrMarkerSpaceCreateInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nmarkerDetector(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MARKERDETECTOR);
    }

    public static long nmarker(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MARKER);
    }

    public static XrPosef nposeInMarkerSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINMARKERSPACE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nmarkerDetector(long struct, XrMarkerDetectorML value) {
        MemoryUtil.memPutAddress(struct + (long)MARKERDETECTOR, value.address());
    }

    public static void nmarker(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MARKER, value);
    }

    public static void nposeInMarkerSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINMARKERSPACE, XrPosef.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MARKERDETECTOR));
    }

    static {
        Struct.Layout layout = XrMarkerSpaceCreateInfoML.__struct(XrMarkerSpaceCreateInfoML.__member(4), XrMarkerSpaceCreateInfoML.__member(POINTER_SIZE), XrMarkerSpaceCreateInfoML.__member(POINTER_SIZE), XrMarkerSpaceCreateInfoML.__member(8), XrMarkerSpaceCreateInfoML.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MARKERDETECTOR = layout.offsetof(2);
        MARKER = layout.offsetof(3);
        POSEINMARKERSPACE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerSpaceCreateInfoML, Buffer>
    implements NativeResource {
        private static final XrMarkerSpaceCreateInfoML ELEMENT_FACTORY = XrMarkerSpaceCreateInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrMarkerSpaceCreateInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerSpaceCreateInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerSpaceCreateInfoML.nnext(this.address());
        }

        @NativeType(value="XrMarkerDetectorML")
        public long markerDetector() {
            return XrMarkerSpaceCreateInfoML.nmarkerDetector(this.address());
        }

        @NativeType(value="XrMarkerML")
        public long marker() {
            return XrMarkerSpaceCreateInfoML.nmarker(this.address());
        }

        public XrPosef poseInMarkerSpace() {
            return XrMarkerSpaceCreateInfoML.nposeInMarkerSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerSpaceCreateInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138008);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerSpaceCreateInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer markerDetector(XrMarkerDetectorML value) {
            XrMarkerSpaceCreateInfoML.nmarkerDetector(this.address(), value);
            return this;
        }

        public Buffer marker(@NativeType(value="XrMarkerML") long value) {
            XrMarkerSpaceCreateInfoML.nmarker(this.address(), value);
            return this;
        }

        public Buffer poseInMarkerSpace(XrPosef value) {
            XrMarkerSpaceCreateInfoML.nposeInMarkerSpace(this.address(), value);
            return this;
        }

        public Buffer poseInMarkerSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInMarkerSpace());
            return this;
        }
    }
}

