/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrOffset2Df
extends Struct<XrOffset2Df>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected XrOffset2Df(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrOffset2Df create(long address, @Nullable ByteBuffer container) {
        return new XrOffset2Df(address, container);
    }

    public XrOffset2Df(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrOffset2Df.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrOffset2Df.nx(this.address());
    }

    public float y() {
        return XrOffset2Df.ny(this.address());
    }

    public XrOffset2Df x(float value) {
        XrOffset2Df.nx(this.address(), value);
        return this;
    }

    public XrOffset2Df y(float value) {
        XrOffset2Df.ny(this.address(), value);
        return this;
    }

    public XrOffset2Df set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public XrOffset2Df set(XrOffset2Df src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrOffset2Df malloc() {
        return new XrOffset2Df(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrOffset2Df calloc() {
        return new XrOffset2Df(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrOffset2Df create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrOffset2Df(MemoryUtil.memAddress(container), container);
    }

    public static XrOffset2Df create(long address) {
        return new XrOffset2Df(address, null);
    }

    public static @Nullable XrOffset2Df createSafe(long address) {
        return address == 0L ? null : new XrOffset2Df(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrOffset2Df.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrOffset2Df.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrOffset2Df malloc(MemoryStack stack) {
        return new XrOffset2Df(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrOffset2Df calloc(MemoryStack stack) {
        return new XrOffset2Df(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = XrOffset2Df.__struct(XrOffset2Df.__member(4), XrOffset2Df.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrOffset2Df, Buffer>
    implements NativeResource {
        private static final XrOffset2Df ELEMENT_FACTORY = XrOffset2Df.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrOffset2Df getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrOffset2Df.nx(this.address());
        }

        public float y() {
            return XrOffset2Df.ny(this.address());
        }

        public Buffer x(float value) {
            XrOffset2Df.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrOffset2Df.ny(this.address(), value);
            return this;
        }
    }
}

