/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrOffset2Di
extends Struct<XrOffset2Di>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected XrOffset2Di(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrOffset2Di create(long address, @Nullable ByteBuffer container) {
        return new XrOffset2Di(address, container);
    }

    public XrOffset2Di(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrOffset2Di.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int x() {
        return XrOffset2Di.nx(this.address());
    }

    @NativeType(value="int32_t")
    public int y() {
        return XrOffset2Di.ny(this.address());
    }

    public XrOffset2Di x(@NativeType(value="int32_t") int value) {
        XrOffset2Di.nx(this.address(), value);
        return this;
    }

    public XrOffset2Di y(@NativeType(value="int32_t") int value) {
        XrOffset2Di.ny(this.address(), value);
        return this;
    }

    public XrOffset2Di set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public XrOffset2Di set(XrOffset2Di src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrOffset2Di malloc() {
        return new XrOffset2Di(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrOffset2Di calloc() {
        return new XrOffset2Di(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrOffset2Di create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrOffset2Di(MemoryUtil.memAddress(container), container);
    }

    public static XrOffset2Di create(long address) {
        return new XrOffset2Di(address, null);
    }

    public static @Nullable XrOffset2Di createSafe(long address) {
        return address == 0L ? null : new XrOffset2Di(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrOffset2Di.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrOffset2Di.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrOffset2Di malloc(MemoryStack stack) {
        return new XrOffset2Di(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrOffset2Di calloc(MemoryStack stack) {
        return new XrOffset2Di(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = XrOffset2Di.__struct(XrOffset2Di.__member(4), XrOffset2Di.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrOffset2Di, Buffer>
    implements NativeResource {
        private static final XrOffset2Di ELEMENT_FACTORY = XrOffset2Di.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrOffset2Di getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int x() {
            return XrOffset2Di.nx(this.address());
        }

        @NativeType(value="int32_t")
        public int y() {
            return XrOffset2Di.ny(this.address());
        }

        public Buffer x(@NativeType(value="int32_t") int value) {
            XrOffset2Di.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int32_t") int value) {
            XrOffset2Di.ny(this.address(), value);
            return this;
        }
    }
}

