/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrColor4f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughColorMapMonoToRgbaFB
extends Struct<XrPassthroughColorMapMonoToRgbaFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int TEXTURECOLORMAP;

    protected XrPassthroughColorMapMonoToRgbaFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrPassthroughColorMapMonoToRgbaFB create(long address, @Nullable ByteBuffer container) {
        return new XrPassthroughColorMapMonoToRgbaFB(address, container);
    }

    public XrPassthroughColorMapMonoToRgbaFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrPassthroughColorMapMonoToRgbaFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughColorMapMonoToRgbaFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughColorMapMonoToRgbaFB.nnext(this.address());
    }

    @NativeType(value="XrColor4f[XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB]")
    public XrColor4f.Buffer textureColorMap() {
        return XrPassthroughColorMapMonoToRgbaFB.ntextureColorMap(this.address());
    }

    public XrColor4f textureColorMap(int index) {
        return XrPassthroughColorMapMonoToRgbaFB.ntextureColorMap(this.address(), index);
    }

    public XrPassthroughColorMapMonoToRgbaFB type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughColorMapMonoToRgbaFB.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughColorMapMonoToRgbaFB type$Default() {
        return this.type(1000118021);
    }

    public XrPassthroughColorMapMonoToRgbaFB next(@NativeType(value="void const *") long value) {
        XrPassthroughColorMapMonoToRgbaFB.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughColorMapMonoToRgbaFB textureColorMap(@NativeType(value="XrColor4f[XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB]") XrColor4f.Buffer value) {
        XrPassthroughColorMapMonoToRgbaFB.ntextureColorMap(this.address(), value);
        return this;
    }

    public XrPassthroughColorMapMonoToRgbaFB textureColorMap(int index, XrColor4f value) {
        XrPassthroughColorMapMonoToRgbaFB.ntextureColorMap(this.address(), index, value);
        return this;
    }

    public XrPassthroughColorMapMonoToRgbaFB textureColorMap(Consumer<XrColor4f.Buffer> consumer) {
        consumer.accept(this.textureColorMap());
        return this;
    }

    public XrPassthroughColorMapMonoToRgbaFB textureColorMap(int index, Consumer<XrColor4f> consumer) {
        consumer.accept(this.textureColorMap(index));
        return this;
    }

    public XrPassthroughColorMapMonoToRgbaFB set(int type, long next, XrColor4f.Buffer textureColorMap) {
        this.type(type);
        this.next(next);
        this.textureColorMap(textureColorMap);
        return this;
    }

    public XrPassthroughColorMapMonoToRgbaFB set(XrPassthroughColorMapMonoToRgbaFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrPassthroughColorMapMonoToRgbaFB malloc() {
        return new XrPassthroughColorMapMonoToRgbaFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrPassthroughColorMapMonoToRgbaFB calloc() {
        return new XrPassthroughColorMapMonoToRgbaFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrPassthroughColorMapMonoToRgbaFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrPassthroughColorMapMonoToRgbaFB(MemoryUtil.memAddress(container), container);
    }

    public static XrPassthroughColorMapMonoToRgbaFB create(long address) {
        return new XrPassthroughColorMapMonoToRgbaFB(address, null);
    }

    public static @Nullable XrPassthroughColorMapMonoToRgbaFB createSafe(long address) {
        return address == 0L ? null : new XrPassthroughColorMapMonoToRgbaFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrPassthroughColorMapMonoToRgbaFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughColorMapMonoToRgbaFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPassthroughColorMapMonoToRgbaFB malloc(MemoryStack stack) {
        return new XrPassthroughColorMapMonoToRgbaFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPassthroughColorMapMonoToRgbaFB calloc(MemoryStack stack) {
        return new XrPassthroughColorMapMonoToRgbaFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static XrColor4f.Buffer ntextureColorMap(long struct) {
        return XrColor4f.create(struct + (long)TEXTURECOLORMAP, 256);
    }

    public static XrColor4f ntextureColorMap(long struct, int index) {
        return XrColor4f.create(struct + (long)TEXTURECOLORMAP + Checks.check(index, 256) * (long)XrColor4f.SIZEOF);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ntextureColorMap(long struct, XrColor4f.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)TEXTURECOLORMAP, value.remaining() * XrColor4f.SIZEOF);
    }

    public static void ntextureColorMap(long struct, int index, XrColor4f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXTURECOLORMAP + Checks.check(index, 256) * (long)XrColor4f.SIZEOF, XrColor4f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrPassthroughColorMapMonoToRgbaFB.__struct(XrPassthroughColorMapMonoToRgbaFB.__member(4), XrPassthroughColorMapMonoToRgbaFB.__member(POINTER_SIZE), XrPassthroughColorMapMonoToRgbaFB.__array(XrColor4f.SIZEOF, XrColor4f.ALIGNOF, 256));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        TEXTURECOLORMAP = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughColorMapMonoToRgbaFB, Buffer>
    implements NativeResource {
        private static final XrPassthroughColorMapMonoToRgbaFB ELEMENT_FACTORY = XrPassthroughColorMapMonoToRgbaFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrPassthroughColorMapMonoToRgbaFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughColorMapMonoToRgbaFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughColorMapMonoToRgbaFB.nnext(this.address());
        }

        @NativeType(value="XrColor4f[XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB]")
        public XrColor4f.Buffer textureColorMap() {
            return XrPassthroughColorMapMonoToRgbaFB.ntextureColorMap(this.address());
        }

        public XrColor4f textureColorMap(int index) {
            return XrPassthroughColorMapMonoToRgbaFB.ntextureColorMap(this.address(), index);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughColorMapMonoToRgbaFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118021);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughColorMapMonoToRgbaFB.nnext(this.address(), value);
            return this;
        }

        public Buffer textureColorMap(@NativeType(value="XrColor4f[XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB]") XrColor4f.Buffer value) {
            XrPassthroughColorMapMonoToRgbaFB.ntextureColorMap(this.address(), value);
            return this;
        }

        public Buffer textureColorMap(int index, XrColor4f value) {
            XrPassthroughColorMapMonoToRgbaFB.ntextureColorMap(this.address(), index, value);
            return this;
        }

        public Buffer textureColorMap(Consumer<XrColor4f.Buffer> consumer) {
            consumer.accept(this.textureColorMap());
            return this;
        }

        public Buffer textureColorMap(int index, Consumer<XrColor4f> consumer) {
            consumer.accept(this.textureColorMap(index));
            return this;
        }
    }
}

