/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughCreateInfoHTC
extends Struct<XrPassthroughCreateInfoHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FORM;

    protected XrPassthroughCreateInfoHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrPassthroughCreateInfoHTC create(long address, @Nullable ByteBuffer container) {
        return new XrPassthroughCreateInfoHTC(address, container);
    }

    public XrPassthroughCreateInfoHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrPassthroughCreateInfoHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughCreateInfoHTC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughCreateInfoHTC.nnext(this.address());
    }

    @NativeType(value="XrPassthroughFormHTC")
    public int form() {
        return XrPassthroughCreateInfoHTC.nform(this.address());
    }

    public XrPassthroughCreateInfoHTC type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughCreateInfoHTC.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughCreateInfoHTC type$Default() {
        return this.type(1000317001);
    }

    public XrPassthroughCreateInfoHTC next(@NativeType(value="void const *") long value) {
        XrPassthroughCreateInfoHTC.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughCreateInfoHTC form(@NativeType(value="XrPassthroughFormHTC") int value) {
        XrPassthroughCreateInfoHTC.nform(this.address(), value);
        return this;
    }

    public XrPassthroughCreateInfoHTC set(int type, long next, int form) {
        this.type(type);
        this.next(next);
        this.form(form);
        return this;
    }

    public XrPassthroughCreateInfoHTC set(XrPassthroughCreateInfoHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrPassthroughCreateInfoHTC malloc() {
        return new XrPassthroughCreateInfoHTC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrPassthroughCreateInfoHTC calloc() {
        return new XrPassthroughCreateInfoHTC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrPassthroughCreateInfoHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrPassthroughCreateInfoHTC(MemoryUtil.memAddress(container), container);
    }

    public static XrPassthroughCreateInfoHTC create(long address) {
        return new XrPassthroughCreateInfoHTC(address, null);
    }

    public static @Nullable XrPassthroughCreateInfoHTC createSafe(long address) {
        return address == 0L ? null : new XrPassthroughCreateInfoHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrPassthroughCreateInfoHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughCreateInfoHTC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPassthroughCreateInfoHTC malloc(MemoryStack stack) {
        return new XrPassthroughCreateInfoHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPassthroughCreateInfoHTC calloc(MemoryStack stack) {
        return new XrPassthroughCreateInfoHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nform(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORM);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nform(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORM, value);
    }

    static {
        Struct.Layout layout = XrPassthroughCreateInfoHTC.__struct(XrPassthroughCreateInfoHTC.__member(4), XrPassthroughCreateInfoHTC.__member(POINTER_SIZE), XrPassthroughCreateInfoHTC.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FORM = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughCreateInfoHTC, Buffer>
    implements NativeResource {
        private static final XrPassthroughCreateInfoHTC ELEMENT_FACTORY = XrPassthroughCreateInfoHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrPassthroughCreateInfoHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughCreateInfoHTC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughCreateInfoHTC.nnext(this.address());
        }

        @NativeType(value="XrPassthroughFormHTC")
        public int form() {
            return XrPassthroughCreateInfoHTC.nform(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughCreateInfoHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000317001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughCreateInfoHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer form(@NativeType(value="XrPassthroughFormHTC") int value) {
            XrPassthroughCreateInfoHTC.nform(this.address(), value);
            return this;
        }
    }
}

