/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPassthroughFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughLayerCreateInfoFB
extends Struct<XrPassthroughLayerCreateInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PASSTHROUGH;
    public static final int FLAGS;
    public static final int PURPOSE;

    protected XrPassthroughLayerCreateInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrPassthroughLayerCreateInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrPassthroughLayerCreateInfoFB(address, container);
    }

    public XrPassthroughLayerCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrPassthroughLayerCreateInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughLayerCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughLayerCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrPassthroughFB")
    public long passthrough() {
        return XrPassthroughLayerCreateInfoFB.npassthrough(this.address());
    }

    @NativeType(value="XrPassthroughFlagsFB")
    public long flags() {
        return XrPassthroughLayerCreateInfoFB.nflags(this.address());
    }

    @NativeType(value="XrPassthroughLayerPurposeFB")
    public int purpose() {
        return XrPassthroughLayerCreateInfoFB.npurpose(this.address());
    }

    public XrPassthroughLayerCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughLayerCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB type$Default() {
        return this.type(1000118002);
    }

    public XrPassthroughLayerCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrPassthroughLayerCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB passthrough(XrPassthroughFB value) {
        XrPassthroughLayerCreateInfoFB.npassthrough(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB flags(@NativeType(value="XrPassthroughFlagsFB") long value) {
        XrPassthroughLayerCreateInfoFB.nflags(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB purpose(@NativeType(value="XrPassthroughLayerPurposeFB") int value) {
        XrPassthroughLayerCreateInfoFB.npurpose(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB set(int type, long next, XrPassthroughFB passthrough, long flags, int purpose) {
        this.type(type);
        this.next(next);
        this.passthrough(passthrough);
        this.flags(flags);
        this.purpose(purpose);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB set(XrPassthroughLayerCreateInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrPassthroughLayerCreateInfoFB malloc() {
        return new XrPassthroughLayerCreateInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrPassthroughLayerCreateInfoFB calloc() {
        return new XrPassthroughLayerCreateInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrPassthroughLayerCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrPassthroughLayerCreateInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrPassthroughLayerCreateInfoFB create(long address) {
        return new XrPassthroughLayerCreateInfoFB(address, null);
    }

    public static @Nullable XrPassthroughLayerCreateInfoFB createSafe(long address) {
        return address == 0L ? null : new XrPassthroughLayerCreateInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrPassthroughLayerCreateInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughLayerCreateInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPassthroughLayerCreateInfoFB malloc(MemoryStack stack) {
        return new XrPassthroughLayerCreateInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPassthroughLayerCreateInfoFB calloc(MemoryStack stack) {
        return new XrPassthroughLayerCreateInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long npassthrough(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PASSTHROUGH);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLAGS);
    }

    public static int npurpose(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PURPOSE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void npassthrough(long struct, XrPassthroughFB value) {
        MemoryUtil.memPutAddress(struct + (long)PASSTHROUGH, value.address());
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FLAGS, value);
    }

    public static void npurpose(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PURPOSE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PASSTHROUGH));
    }

    static {
        Struct.Layout layout = XrPassthroughLayerCreateInfoFB.__struct(XrPassthroughLayerCreateInfoFB.__member(4), XrPassthroughLayerCreateInfoFB.__member(POINTER_SIZE), XrPassthroughLayerCreateInfoFB.__member(POINTER_SIZE), XrPassthroughLayerCreateInfoFB.__member(8), XrPassthroughLayerCreateInfoFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PASSTHROUGH = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        PURPOSE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughLayerCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrPassthroughLayerCreateInfoFB ELEMENT_FACTORY = XrPassthroughLayerCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrPassthroughLayerCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughLayerCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughLayerCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrPassthroughFB")
        public long passthrough() {
            return XrPassthroughLayerCreateInfoFB.npassthrough(this.address());
        }

        @NativeType(value="XrPassthroughFlagsFB")
        public long flags() {
            return XrPassthroughLayerCreateInfoFB.nflags(this.address());
        }

        @NativeType(value="XrPassthroughLayerPurposeFB")
        public int purpose() {
            return XrPassthroughLayerCreateInfoFB.npurpose(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughLayerCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughLayerCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer passthrough(XrPassthroughFB value) {
            XrPassthroughLayerCreateInfoFB.npassthrough(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrPassthroughFlagsFB") long value) {
            XrPassthroughLayerCreateInfoFB.nflags(this.address(), value);
            return this;
        }

        public Buffer purpose(@NativeType(value="XrPassthroughLayerPurposeFB") int value) {
            XrPassthroughLayerCreateInfoFB.npurpose(this.address(), value);
            return this;
        }
    }
}

