/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughMeshTransformInfoHTC
extends Struct<XrPassthroughMeshTransformInfoHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VERTEXCOUNT;
    public static final int VERTICES;
    public static final int INDEXCOUNT;
    public static final int INDICES;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int POSE;
    public static final int SCALE;

    protected XrPassthroughMeshTransformInfoHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrPassthroughMeshTransformInfoHTC create(long address, @Nullable ByteBuffer container) {
        return new XrPassthroughMeshTransformInfoHTC(address, container);
    }

    public XrPassthroughMeshTransformInfoHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrPassthroughMeshTransformInfoHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughMeshTransformInfoHTC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughMeshTransformInfoHTC.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCount() {
        return XrPassthroughMeshTransformInfoHTC.nvertexCount(this.address());
    }

    @NativeType(value="XrVector3f const *")
    public XrVector3f.Buffer vertices() {
        return XrPassthroughMeshTransformInfoHTC.nvertices(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCount() {
        return XrPassthroughMeshTransformInfoHTC.nindexCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer indices() {
        return XrPassthroughMeshTransformInfoHTC.nindices(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrPassthroughMeshTransformInfoHTC.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrPassthroughMeshTransformInfoHTC.ntime(this.address());
    }

    public XrPosef pose() {
        return XrPassthroughMeshTransformInfoHTC.npose(this.address());
    }

    public XrVector3f scale() {
        return XrPassthroughMeshTransformInfoHTC.nscale(this.address());
    }

    public XrPassthroughMeshTransformInfoHTC type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughMeshTransformInfoHTC.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC type$Default() {
        return this.type(1000317003);
    }

    public XrPassthroughMeshTransformInfoHTC next(@NativeType(value="void const *") long value) {
        XrPassthroughMeshTransformInfoHTC.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC vertices(@NativeType(value="XrVector3f const *") XrVector3f.Buffer value) {
        XrPassthroughMeshTransformInfoHTC.nvertices(this.address(), value);
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC indices(@NativeType(value="uint32_t const *") IntBuffer value) {
        XrPassthroughMeshTransformInfoHTC.nindices(this.address(), value);
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC baseSpace(XrSpace value) {
        XrPassthroughMeshTransformInfoHTC.nbaseSpace(this.address(), value);
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC time(@NativeType(value="XrTime") long value) {
        XrPassthroughMeshTransformInfoHTC.ntime(this.address(), value);
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC pose(XrPosef value) {
        XrPassthroughMeshTransformInfoHTC.npose(this.address(), value);
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC scale(XrVector3f value) {
        XrPassthroughMeshTransformInfoHTC.nscale(this.address(), value);
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC scale(Consumer<XrVector3f> consumer) {
        consumer.accept(this.scale());
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC set(int type, long next, XrVector3f.Buffer vertices, IntBuffer indices, XrSpace baseSpace, long time, XrPosef pose, XrVector3f scale) {
        this.type(type);
        this.next(next);
        this.vertices(vertices);
        this.indices(indices);
        this.baseSpace(baseSpace);
        this.time(time);
        this.pose(pose);
        this.scale(scale);
        return this;
    }

    public XrPassthroughMeshTransformInfoHTC set(XrPassthroughMeshTransformInfoHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrPassthroughMeshTransformInfoHTC malloc() {
        return new XrPassthroughMeshTransformInfoHTC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrPassthroughMeshTransformInfoHTC calloc() {
        return new XrPassthroughMeshTransformInfoHTC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrPassthroughMeshTransformInfoHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrPassthroughMeshTransformInfoHTC(MemoryUtil.memAddress(container), container);
    }

    public static XrPassthroughMeshTransformInfoHTC create(long address) {
        return new XrPassthroughMeshTransformInfoHTC(address, null);
    }

    public static @Nullable XrPassthroughMeshTransformInfoHTC createSafe(long address) {
        return address == 0L ? null : new XrPassthroughMeshTransformInfoHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrPassthroughMeshTransformInfoHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughMeshTransformInfoHTC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPassthroughMeshTransformInfoHTC malloc(MemoryStack stack) {
        return new XrPassthroughMeshTransformInfoHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPassthroughMeshTransformInfoHTC calloc(MemoryStack stack) {
        return new XrPassthroughMeshTransformInfoHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nvertexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXCOUNT);
    }

    public static XrVector3f.Buffer nvertices(long struct) {
        return XrVector3f.create(MemoryUtil.memGetAddress(struct + (long)VERTICES), XrPassthroughMeshTransformInfoHTC.nvertexCount(struct));
    }

    public static int nindexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEXCOUNT);
    }

    public static IntBuffer nindices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)INDICES), XrPassthroughMeshTransformInfoHTC.nindexCount(struct));
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BASESPACE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrVector3f nscale(long struct) {
        return XrVector3f.create(struct + (long)SCALE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nvertexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXCOUNT, value);
    }

    public static void nvertices(long struct, XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTICES, value.address());
        XrPassthroughMeshTransformInfoHTC.nvertexCount(struct, value.remaining());
    }

    public static void nindexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDEXCOUNT, value);
    }

    public static void nindices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDICES, MemoryUtil.memAddress(value));
        XrPassthroughMeshTransformInfoHTC.nindexCount(struct, value.remaining());
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)BASESPACE, value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nscale(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCALE, XrVector3f.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTICES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INDICES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BASESPACE));
    }

    static {
        Struct.Layout layout = XrPassthroughMeshTransformInfoHTC.__struct(XrPassthroughMeshTransformInfoHTC.__member(4), XrPassthroughMeshTransformInfoHTC.__member(POINTER_SIZE), XrPassthroughMeshTransformInfoHTC.__member(4), XrPassthroughMeshTransformInfoHTC.__member(POINTER_SIZE), XrPassthroughMeshTransformInfoHTC.__member(4), XrPassthroughMeshTransformInfoHTC.__member(POINTER_SIZE), XrPassthroughMeshTransformInfoHTC.__member(POINTER_SIZE), XrPassthroughMeshTransformInfoHTC.__member(8), XrPassthroughMeshTransformInfoHTC.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrPassthroughMeshTransformInfoHTC.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VERTEXCOUNT = layout.offsetof(2);
        VERTICES = layout.offsetof(3);
        INDEXCOUNT = layout.offsetof(4);
        INDICES = layout.offsetof(5);
        BASESPACE = layout.offsetof(6);
        TIME = layout.offsetof(7);
        POSE = layout.offsetof(8);
        SCALE = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughMeshTransformInfoHTC, Buffer>
    implements NativeResource {
        private static final XrPassthroughMeshTransformInfoHTC ELEMENT_FACTORY = XrPassthroughMeshTransformInfoHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrPassthroughMeshTransformInfoHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughMeshTransformInfoHTC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughMeshTransformInfoHTC.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCount() {
            return XrPassthroughMeshTransformInfoHTC.nvertexCount(this.address());
        }

        @NativeType(value="XrVector3f const *")
        public XrVector3f.Buffer vertices() {
            return XrPassthroughMeshTransformInfoHTC.nvertices(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCount() {
            return XrPassthroughMeshTransformInfoHTC.nindexCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer indices() {
            return XrPassthroughMeshTransformInfoHTC.nindices(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrPassthroughMeshTransformInfoHTC.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrPassthroughMeshTransformInfoHTC.ntime(this.address());
        }

        public XrPosef pose() {
            return XrPassthroughMeshTransformInfoHTC.npose(this.address());
        }

        public XrVector3f scale() {
            return XrPassthroughMeshTransformInfoHTC.nscale(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughMeshTransformInfoHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000317003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughMeshTransformInfoHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer vertices(@NativeType(value="XrVector3f const *") XrVector3f.Buffer value) {
            XrPassthroughMeshTransformInfoHTC.nvertices(this.address(), value);
            return this;
        }

        public Buffer indices(@NativeType(value="uint32_t const *") IntBuffer value) {
            XrPassthroughMeshTransformInfoHTC.nindices(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrPassthroughMeshTransformInfoHTC.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrPassthroughMeshTransformInfoHTC.ntime(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrPassthroughMeshTransformInfoHTC.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer scale(XrVector3f value) {
            XrPassthroughMeshTransformInfoHTC.nscale(this.address(), value);
            return this;
        }

        public Buffer scale(Consumer<XrVector3f> consumer) {
            consumer.accept(this.scale());
            return this;
        }
    }
}

