/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent3DfEXT;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPlaneDetectorBeginInfoEXT
extends Struct<XrPlaneDetectorBeginInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int ORIENTATIONCOUNT;
    public static final int ORIENTATIONS;
    public static final int SEMANTICTYPECOUNT;
    public static final int SEMANTICTYPES;
    public static final int MAXPLANES;
    public static final int MINAREA;
    public static final int BOUNDINGBOXPOSE;
    public static final int BOUNDINGBOXEXTENT;

    protected XrPlaneDetectorBeginInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrPlaneDetectorBeginInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new XrPlaneDetectorBeginInfoEXT(address, container);
    }

    public XrPlaneDetectorBeginInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrPlaneDetectorBeginInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPlaneDetectorBeginInfoEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPlaneDetectorBeginInfoEXT.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrPlaneDetectorBeginInfoEXT.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrPlaneDetectorBeginInfoEXT.ntime(this.address());
    }

    @NativeType(value="uint32_t")
    public int orientationCount() {
        return XrPlaneDetectorBeginInfoEXT.norientationCount(this.address());
    }

    @NativeType(value="XrPlaneDetectorOrientationEXT const *")
    public @Nullable IntBuffer orientations() {
        return XrPlaneDetectorBeginInfoEXT.norientations(this.address());
    }

    @NativeType(value="uint32_t")
    public int semanticTypeCount() {
        return XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(this.address());
    }

    @NativeType(value="XrPlaneDetectorSemanticTypeEXT const *")
    public @Nullable IntBuffer semanticTypes() {
        return XrPlaneDetectorBeginInfoEXT.nsemanticTypes(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPlanes() {
        return XrPlaneDetectorBeginInfoEXT.nmaxPlanes(this.address());
    }

    public float minArea() {
        return XrPlaneDetectorBeginInfoEXT.nminArea(this.address());
    }

    public XrPosef boundingBoxPose() {
        return XrPlaneDetectorBeginInfoEXT.nboundingBoxPose(this.address());
    }

    public XrExtent3DfEXT boundingBoxExtent() {
        return XrPlaneDetectorBeginInfoEXT.nboundingBoxExtent(this.address());
    }

    public XrPlaneDetectorBeginInfoEXT type(@NativeType(value="XrStructureType") int value) {
        XrPlaneDetectorBeginInfoEXT.ntype(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT type$Default() {
        return this.type(1000429002);
    }

    public XrPlaneDetectorBeginInfoEXT next(@NativeType(value="void const *") long value) {
        XrPlaneDetectorBeginInfoEXT.nnext(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT baseSpace(XrSpace value) {
        XrPlaneDetectorBeginInfoEXT.nbaseSpace(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT time(@NativeType(value="XrTime") long value) {
        XrPlaneDetectorBeginInfoEXT.ntime(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT orientationCount(@NativeType(value="uint32_t") int value) {
        XrPlaneDetectorBeginInfoEXT.norientationCount(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT orientations(@NativeType(value="XrPlaneDetectorOrientationEXT const *") @Nullable IntBuffer value) {
        XrPlaneDetectorBeginInfoEXT.norientations(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT semanticTypeCount(@NativeType(value="uint32_t") int value) {
        XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT semanticTypes(@NativeType(value="XrPlaneDetectorSemanticTypeEXT const *") @Nullable IntBuffer value) {
        XrPlaneDetectorBeginInfoEXT.nsemanticTypes(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT maxPlanes(@NativeType(value="uint32_t") int value) {
        XrPlaneDetectorBeginInfoEXT.nmaxPlanes(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT minArea(float value) {
        XrPlaneDetectorBeginInfoEXT.nminArea(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT boundingBoxPose(XrPosef value) {
        XrPlaneDetectorBeginInfoEXT.nboundingBoxPose(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT boundingBoxPose(Consumer<XrPosef> consumer) {
        consumer.accept(this.boundingBoxPose());
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT boundingBoxExtent(XrExtent3DfEXT value) {
        XrPlaneDetectorBeginInfoEXT.nboundingBoxExtent(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT boundingBoxExtent(Consumer<XrExtent3DfEXT> consumer) {
        consumer.accept(this.boundingBoxExtent());
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT set(int type, long next, XrSpace baseSpace, long time, int orientationCount, @Nullable IntBuffer orientations, int semanticTypeCount, @Nullable IntBuffer semanticTypes, int maxPlanes, float minArea, XrPosef boundingBoxPose, XrExtent3DfEXT boundingBoxExtent) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.orientationCount(orientationCount);
        this.orientations(orientations);
        this.semanticTypeCount(semanticTypeCount);
        this.semanticTypes(semanticTypes);
        this.maxPlanes(maxPlanes);
        this.minArea(minArea);
        this.boundingBoxPose(boundingBoxPose);
        this.boundingBoxExtent(boundingBoxExtent);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT set(XrPlaneDetectorBeginInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrPlaneDetectorBeginInfoEXT malloc() {
        return new XrPlaneDetectorBeginInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrPlaneDetectorBeginInfoEXT calloc() {
        return new XrPlaneDetectorBeginInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrPlaneDetectorBeginInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrPlaneDetectorBeginInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrPlaneDetectorBeginInfoEXT create(long address) {
        return new XrPlaneDetectorBeginInfoEXT(address, null);
    }

    public static @Nullable XrPlaneDetectorBeginInfoEXT createSafe(long address) {
        return address == 0L ? null : new XrPlaneDetectorBeginInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrPlaneDetectorBeginInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPlaneDetectorBeginInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPlaneDetectorBeginInfoEXT malloc(MemoryStack stack) {
        return new XrPlaneDetectorBeginInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPlaneDetectorBeginInfoEXT calloc(MemoryStack stack) {
        return new XrPlaneDetectorBeginInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BASESPACE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static int norientationCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ORIENTATIONCOUNT);
    }

    public static @Nullable IntBuffer norientations(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)ORIENTATIONS), XrPlaneDetectorBeginInfoEXT.norientationCount(struct));
    }

    public static int nsemanticTypeCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SEMANTICTYPECOUNT);
    }

    public static @Nullable IntBuffer nsemanticTypes(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)SEMANTICTYPES), XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(struct));
    }

    public static int nmaxPlanes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPLANES);
    }

    public static float nminArea(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MINAREA);
    }

    public static XrPosef nboundingBoxPose(long struct) {
        return XrPosef.create(struct + (long)BOUNDINGBOXPOSE);
    }

    public static XrExtent3DfEXT nboundingBoxExtent(long struct) {
        return XrExtent3DfEXT.create(struct + (long)BOUNDINGBOXEXTENT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)BASESPACE, value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void norientationCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ORIENTATIONCOUNT, value);
    }

    public static void norientations(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)ORIENTATIONS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrPlaneDetectorBeginInfoEXT.norientationCount(struct, value.remaining());
        }
    }

    public static void nsemanticTypeCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SEMANTICTYPECOUNT, value);
    }

    public static void nsemanticTypes(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SEMANTICTYPES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(struct, value.remaining());
        }
    }

    public static void nmaxPlanes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXPLANES, value);
    }

    public static void nminArea(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MINAREA, value);
    }

    public static void nboundingBoxPose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BOUNDINGBOXPOSE, XrPosef.SIZEOF);
    }

    public static void nboundingBoxExtent(long struct, XrExtent3DfEXT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BOUNDINGBOXEXTENT, XrExtent3DfEXT.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BASESPACE));
    }

    static {
        Struct.Layout layout = XrPlaneDetectorBeginInfoEXT.__struct(XrPlaneDetectorBeginInfoEXT.__member(4), XrPlaneDetectorBeginInfoEXT.__member(POINTER_SIZE), XrPlaneDetectorBeginInfoEXT.__member(POINTER_SIZE), XrPlaneDetectorBeginInfoEXT.__member(8), XrPlaneDetectorBeginInfoEXT.__member(4), XrPlaneDetectorBeginInfoEXT.__member(POINTER_SIZE), XrPlaneDetectorBeginInfoEXT.__member(4), XrPlaneDetectorBeginInfoEXT.__member(POINTER_SIZE), XrPlaneDetectorBeginInfoEXT.__member(4), XrPlaneDetectorBeginInfoEXT.__member(4), XrPlaneDetectorBeginInfoEXT.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrPlaneDetectorBeginInfoEXT.__member(XrExtent3DfEXT.SIZEOF, XrExtent3DfEXT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
        ORIENTATIONCOUNT = layout.offsetof(4);
        ORIENTATIONS = layout.offsetof(5);
        SEMANTICTYPECOUNT = layout.offsetof(6);
        SEMANTICTYPES = layout.offsetof(7);
        MAXPLANES = layout.offsetof(8);
        MINAREA = layout.offsetof(9);
        BOUNDINGBOXPOSE = layout.offsetof(10);
        BOUNDINGBOXEXTENT = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<XrPlaneDetectorBeginInfoEXT, Buffer>
    implements NativeResource {
        private static final XrPlaneDetectorBeginInfoEXT ELEMENT_FACTORY = XrPlaneDetectorBeginInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrPlaneDetectorBeginInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPlaneDetectorBeginInfoEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPlaneDetectorBeginInfoEXT.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrPlaneDetectorBeginInfoEXT.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrPlaneDetectorBeginInfoEXT.ntime(this.address());
        }

        @NativeType(value="uint32_t")
        public int orientationCount() {
            return XrPlaneDetectorBeginInfoEXT.norientationCount(this.address());
        }

        @NativeType(value="XrPlaneDetectorOrientationEXT const *")
        public @Nullable IntBuffer orientations() {
            return XrPlaneDetectorBeginInfoEXT.norientations(this.address());
        }

        @NativeType(value="uint32_t")
        public int semanticTypeCount() {
            return XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(this.address());
        }

        @NativeType(value="XrPlaneDetectorSemanticTypeEXT const *")
        public @Nullable IntBuffer semanticTypes() {
            return XrPlaneDetectorBeginInfoEXT.nsemanticTypes(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPlanes() {
            return XrPlaneDetectorBeginInfoEXT.nmaxPlanes(this.address());
        }

        public float minArea() {
            return XrPlaneDetectorBeginInfoEXT.nminArea(this.address());
        }

        public XrPosef boundingBoxPose() {
            return XrPlaneDetectorBeginInfoEXT.nboundingBoxPose(this.address());
        }

        public XrExtent3DfEXT boundingBoxExtent() {
            return XrPlaneDetectorBeginInfoEXT.nboundingBoxExtent(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPlaneDetectorBeginInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000429002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPlaneDetectorBeginInfoEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrPlaneDetectorBeginInfoEXT.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrPlaneDetectorBeginInfoEXT.ntime(this.address(), value);
            return this;
        }

        public Buffer orientationCount(@NativeType(value="uint32_t") int value) {
            XrPlaneDetectorBeginInfoEXT.norientationCount(this.address(), value);
            return this;
        }

        public Buffer orientations(@NativeType(value="XrPlaneDetectorOrientationEXT const *") @Nullable IntBuffer value) {
            XrPlaneDetectorBeginInfoEXT.norientations(this.address(), value);
            return this;
        }

        public Buffer semanticTypeCount(@NativeType(value="uint32_t") int value) {
            XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(this.address(), value);
            return this;
        }

        public Buffer semanticTypes(@NativeType(value="XrPlaneDetectorSemanticTypeEXT const *") @Nullable IntBuffer value) {
            XrPlaneDetectorBeginInfoEXT.nsemanticTypes(this.address(), value);
            return this;
        }

        public Buffer maxPlanes(@NativeType(value="uint32_t") int value) {
            XrPlaneDetectorBeginInfoEXT.nmaxPlanes(this.address(), value);
            return this;
        }

        public Buffer minArea(float value) {
            XrPlaneDetectorBeginInfoEXT.nminArea(this.address(), value);
            return this;
        }

        public Buffer boundingBoxPose(XrPosef value) {
            XrPlaneDetectorBeginInfoEXT.nboundingBoxPose(this.address(), value);
            return this;
        }

        public Buffer boundingBoxPose(Consumer<XrPosef> consumer) {
            consumer.accept(this.boundingBoxPose());
            return this;
        }

        public Buffer boundingBoxExtent(XrExtent3DfEXT value) {
            XrPlaneDetectorBeginInfoEXT.nboundingBoxExtent(this.address(), value);
            return this;
        }

        public Buffer boundingBoxExtent(Consumer<XrExtent3DfEXT> consumer) {
            consumer.accept(this.boundingBoxExtent());
            return this;
        }
    }
}

