/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPosef
extends Struct<XrPosef>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIENTATION;
    public static final int POSITION;

    protected XrPosef(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrPosef create(long address, @Nullable ByteBuffer container) {
        return new XrPosef(address, container);
    }

    public XrPosef(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrPosef.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public XrQuaternionf orientation() {
        return XrPosef.norientation(this.address());
    }

    public XrVector3f position$() {
        return XrPosef.nposition$(this.address());
    }

    public XrPosef orientation(XrQuaternionf value) {
        XrPosef.norientation(this.address(), value);
        return this;
    }

    public XrPosef orientation(Consumer<XrQuaternionf> consumer) {
        consumer.accept(this.orientation());
        return this;
    }

    public XrPosef position$(XrVector3f value) {
        XrPosef.nposition$(this.address(), value);
        return this;
    }

    public XrPosef position$(Consumer<XrVector3f> consumer) {
        consumer.accept(this.position$());
        return this;
    }

    public XrPosef set(XrQuaternionf orientation, XrVector3f position$) {
        this.orientation(orientation);
        this.position$(position$);
        return this;
    }

    public XrPosef set(XrPosef src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrPosef malloc() {
        return new XrPosef(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrPosef calloc() {
        return new XrPosef(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrPosef create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrPosef(MemoryUtil.memAddress(container), container);
    }

    public static XrPosef create(long address) {
        return new XrPosef(address, null);
    }

    public static @Nullable XrPosef createSafe(long address) {
        return address == 0L ? null : new XrPosef(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrPosef.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPosef.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPosef malloc(MemoryStack stack) {
        return new XrPosef(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPosef calloc(MemoryStack stack) {
        return new XrPosef(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrQuaternionf norientation(long struct) {
        return XrQuaternionf.create(struct + (long)ORIENTATION);
    }

    public static XrVector3f nposition$(long struct) {
        return XrVector3f.create(struct + (long)POSITION);
    }

    public static void norientation(long struct, XrQuaternionf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ORIENTATION, XrQuaternionf.SIZEOF);
    }

    public static void nposition$(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSITION, XrVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrPosef.__struct(XrPosef.__member(XrQuaternionf.SIZEOF, XrQuaternionf.ALIGNOF), XrPosef.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIENTATION = layout.offsetof(0);
        POSITION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrPosef, Buffer>
    implements NativeResource {
        private static final XrPosef ELEMENT_FACTORY = XrPosef.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrPosef getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrQuaternionf orientation() {
            return XrPosef.norientation(this.address());
        }

        public XrVector3f position$() {
            return XrPosef.nposition$(this.address());
        }

        public Buffer orientation(XrQuaternionf value) {
            XrPosef.norientation(this.address(), value);
            return this;
        }

        public Buffer orientation(Consumer<XrQuaternionf> consumer) {
            consumer.accept(this.orientation());
            return this;
        }

        public Buffer position$(XrVector3f value) {
            XrPosef.nposition$(this.address(), value);
            return this;
        }

        public Buffer position$(Consumer<XrVector3f> consumer) {
            consumer.accept(this.position$());
            return this;
        }
    }
}

