/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrRenderModelCapabilitiesRequestFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRenderModelPropertiesFB
extends Struct<XrRenderModelPropertiesFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VENDORID;
    public static final int MODELNAME;
    public static final int MODELKEY;
    public static final int MODELVERSION;
    public static final int FLAGS;

    protected XrRenderModelPropertiesFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrRenderModelPropertiesFB create(long address, @Nullable ByteBuffer container) {
        return new XrRenderModelPropertiesFB(address, container);
    }

    public XrRenderModelPropertiesFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrRenderModelPropertiesFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrRenderModelPropertiesFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrRenderModelPropertiesFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int vendorId() {
        return XrRenderModelPropertiesFB.nvendorId(this.address());
    }

    @NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]")
    public ByteBuffer modelName() {
        return XrRenderModelPropertiesFB.nmodelName(this.address());
    }

    @NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]")
    public String modelNameString() {
        return XrRenderModelPropertiesFB.nmodelNameString(this.address());
    }

    @NativeType(value="XrRenderModelKeyFB")
    public long modelKey() {
        return XrRenderModelPropertiesFB.nmodelKey(this.address());
    }

    @NativeType(value="uint32_t")
    public int modelVersion() {
        return XrRenderModelPropertiesFB.nmodelVersion(this.address());
    }

    @NativeType(value="XrRenderModelFlagsFB")
    public long flags() {
        return XrRenderModelPropertiesFB.nflags(this.address());
    }

    public XrRenderModelPropertiesFB type(@NativeType(value="XrStructureType") int value) {
        XrRenderModelPropertiesFB.ntype(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB type$Default() {
        return this.type(1000119001);
    }

    public XrRenderModelPropertiesFB next(@NativeType(value="void *") long value) {
        XrRenderModelPropertiesFB.nnext(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB next(XrRenderModelCapabilitiesRequestFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrRenderModelPropertiesFB vendorId(@NativeType(value="uint32_t") int value) {
        XrRenderModelPropertiesFB.nvendorId(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB modelName(@NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]") ByteBuffer value) {
        XrRenderModelPropertiesFB.nmodelName(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB modelKey(@NativeType(value="XrRenderModelKeyFB") long value) {
        XrRenderModelPropertiesFB.nmodelKey(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB modelVersion(@NativeType(value="uint32_t") int value) {
        XrRenderModelPropertiesFB.nmodelVersion(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB flags(@NativeType(value="XrRenderModelFlagsFB") long value) {
        XrRenderModelPropertiesFB.nflags(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB set(int type, long next, int vendorId, ByteBuffer modelName, long modelKey, int modelVersion, long flags) {
        this.type(type);
        this.next(next);
        this.vendorId(vendorId);
        this.modelName(modelName);
        this.modelKey(modelKey);
        this.modelVersion(modelVersion);
        this.flags(flags);
        return this;
    }

    public XrRenderModelPropertiesFB set(XrRenderModelPropertiesFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrRenderModelPropertiesFB malloc() {
        return new XrRenderModelPropertiesFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrRenderModelPropertiesFB calloc() {
        return new XrRenderModelPropertiesFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrRenderModelPropertiesFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrRenderModelPropertiesFB(MemoryUtil.memAddress(container), container);
    }

    public static XrRenderModelPropertiesFB create(long address) {
        return new XrRenderModelPropertiesFB(address, null);
    }

    public static @Nullable XrRenderModelPropertiesFB createSafe(long address) {
        return address == 0L ? null : new XrRenderModelPropertiesFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrRenderModelPropertiesFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRenderModelPropertiesFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrRenderModelPropertiesFB malloc(MemoryStack stack) {
        return new XrRenderModelPropertiesFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrRenderModelPropertiesFB calloc(MemoryStack stack) {
        return new XrRenderModelPropertiesFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nvendorId(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VENDORID);
    }

    public static ByteBuffer nmodelName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)MODELNAME, 64);
    }

    public static String nmodelNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)MODELNAME);
    }

    public static long nmodelKey(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MODELKEY);
    }

    public static int nmodelVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MODELVERSION);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLAGS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nvendorId(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VENDORID, value);
    }

    public static void nmodelName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)MODELNAME, value.remaining());
    }

    public static void nmodelKey(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MODELKEY, value);
    }

    public static void nmodelVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MODELVERSION, value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = XrRenderModelPropertiesFB.__struct(XrRenderModelPropertiesFB.__member(4), XrRenderModelPropertiesFB.__member(POINTER_SIZE), XrRenderModelPropertiesFB.__member(4), XrRenderModelPropertiesFB.__array(1, 64), XrRenderModelPropertiesFB.__member(8), XrRenderModelPropertiesFB.__member(4), XrRenderModelPropertiesFB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VENDORID = layout.offsetof(2);
        MODELNAME = layout.offsetof(3);
        MODELKEY = layout.offsetof(4);
        MODELVERSION = layout.offsetof(5);
        FLAGS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrRenderModelPropertiesFB, Buffer>
    implements NativeResource {
        private static final XrRenderModelPropertiesFB ELEMENT_FACTORY = XrRenderModelPropertiesFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrRenderModelPropertiesFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrRenderModelPropertiesFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrRenderModelPropertiesFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int vendorId() {
            return XrRenderModelPropertiesFB.nvendorId(this.address());
        }

        @NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]")
        public ByteBuffer modelName() {
            return XrRenderModelPropertiesFB.nmodelName(this.address());
        }

        @NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]")
        public String modelNameString() {
            return XrRenderModelPropertiesFB.nmodelNameString(this.address());
        }

        @NativeType(value="XrRenderModelKeyFB")
        public long modelKey() {
            return XrRenderModelPropertiesFB.nmodelKey(this.address());
        }

        @NativeType(value="uint32_t")
        public int modelVersion() {
            return XrRenderModelPropertiesFB.nmodelVersion(this.address());
        }

        @NativeType(value="XrRenderModelFlagsFB")
        public long flags() {
            return XrRenderModelPropertiesFB.nflags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrRenderModelPropertiesFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000119001);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrRenderModelPropertiesFB.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrRenderModelCapabilitiesRequestFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer vendorId(@NativeType(value="uint32_t") int value) {
            XrRenderModelPropertiesFB.nvendorId(this.address(), value);
            return this;
        }

        public Buffer modelName(@NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]") ByteBuffer value) {
            XrRenderModelPropertiesFB.nmodelName(this.address(), value);
            return this;
        }

        public Buffer modelKey(@NativeType(value="XrRenderModelKeyFB") long value) {
            XrRenderModelPropertiesFB.nmodelKey(this.address(), value);
            return this;
        }

        public Buffer modelVersion(@NativeType(value="uint32_t") int value) {
            XrRenderModelPropertiesFB.nmodelVersion(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrRenderModelFlagsFB") long value) {
            XrRenderModelPropertiesFB.nflags(this.address(), value);
            return this;
        }
    }
}

