/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneFrustumBoundMSFT
extends Struct<XrSceneFrustumBoundMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSE;
    public static final int FOV;
    public static final int FARDISTANCE;

    protected XrSceneFrustumBoundMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSceneFrustumBoundMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneFrustumBoundMSFT(address, container);
    }

    public XrSceneFrustumBoundMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneFrustumBoundMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public XrPosef pose() {
        return XrSceneFrustumBoundMSFT.npose(this.address());
    }

    public XrFovf fov() {
        return XrSceneFrustumBoundMSFT.nfov(this.address());
    }

    public float farDistance() {
        return XrSceneFrustumBoundMSFT.nfarDistance(this.address());
    }

    public XrSceneFrustumBoundMSFT pose(XrPosef value) {
        XrSceneFrustumBoundMSFT.npose(this.address(), value);
        return this;
    }

    public XrSceneFrustumBoundMSFT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSceneFrustumBoundMSFT fov(XrFovf value) {
        XrSceneFrustumBoundMSFT.nfov(this.address(), value);
        return this;
    }

    public XrSceneFrustumBoundMSFT fov(Consumer<XrFovf> consumer) {
        consumer.accept(this.fov());
        return this;
    }

    public XrSceneFrustumBoundMSFT farDistance(float value) {
        XrSceneFrustumBoundMSFT.nfarDistance(this.address(), value);
        return this;
    }

    public XrSceneFrustumBoundMSFT set(XrPosef pose, XrFovf fov, float farDistance) {
        this.pose(pose);
        this.fov(fov);
        this.farDistance(farDistance);
        return this;
    }

    public XrSceneFrustumBoundMSFT set(XrSceneFrustumBoundMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneFrustumBoundMSFT malloc() {
        return new XrSceneFrustumBoundMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSceneFrustumBoundMSFT calloc() {
        return new XrSceneFrustumBoundMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSceneFrustumBoundMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSceneFrustumBoundMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrSceneFrustumBoundMSFT create(long address) {
        return new XrSceneFrustumBoundMSFT(address, null);
    }

    public static @Nullable XrSceneFrustumBoundMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneFrustumBoundMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSceneFrustumBoundMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneFrustumBoundMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneFrustumBoundMSFT malloc(MemoryStack stack) {
        return new XrSceneFrustumBoundMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneFrustumBoundMSFT calloc(MemoryStack stack) {
        return new XrSceneFrustumBoundMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrFovf nfov(long struct) {
        return XrFovf.create(struct + (long)FOV);
    }

    public static float nfarDistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FARDISTANCE);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nfov(long struct, XrFovf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FOV, XrFovf.SIZEOF);
    }

    public static void nfarDistance(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FARDISTANCE, value);
    }

    static {
        Struct.Layout layout = XrSceneFrustumBoundMSFT.__struct(XrSceneFrustumBoundMSFT.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrSceneFrustumBoundMSFT.__member(XrFovf.SIZEOF, XrFovf.ALIGNOF), XrSceneFrustumBoundMSFT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSE = layout.offsetof(0);
        FOV = layout.offsetof(1);
        FARDISTANCE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSceneFrustumBoundMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneFrustumBoundMSFT ELEMENT_FACTORY = XrSceneFrustumBoundMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSceneFrustumBoundMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrPosef pose() {
            return XrSceneFrustumBoundMSFT.npose(this.address());
        }

        public XrFovf fov() {
            return XrSceneFrustumBoundMSFT.nfov(this.address());
        }

        public float farDistance() {
            return XrSceneFrustumBoundMSFT.nfarDistance(this.address());
        }

        public Buffer pose(XrPosef value) {
            XrSceneFrustumBoundMSFT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer fov(XrFovf value) {
            XrSceneFrustumBoundMSFT.nfov(this.address(), value);
            return this;
        }

        public Buffer fov(Consumer<XrFovf> consumer) {
            consumer.accept(this.fov());
            return this;
        }

        public Buffer farDistance(float value) {
            XrSceneFrustumBoundMSFT.nfarDistance(this.address(), value);
            return this;
        }
    }
}

