/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneMeshBuffersMSFT
extends Struct<XrSceneMeshBuffersMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrSceneMeshBuffersMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSceneMeshBuffersMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneMeshBuffersMSFT(address, container);
    }

    public XrSceneMeshBuffersMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneMeshBuffersMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneMeshBuffersMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneMeshBuffersMSFT.nnext(this.address());
    }

    public XrSceneMeshBuffersMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneMeshBuffersMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneMeshBuffersMSFT type$Default() {
        return this.type(1000097015);
    }

    public XrSceneMeshBuffersMSFT next(@NativeType(value="void *") long value) {
        XrSceneMeshBuffersMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneMeshBuffersMSFT set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSceneMeshBuffersMSFT set(XrSceneMeshBuffersMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneMeshBuffersMSFT malloc() {
        return new XrSceneMeshBuffersMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSceneMeshBuffersMSFT calloc() {
        return new XrSceneMeshBuffersMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSceneMeshBuffersMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSceneMeshBuffersMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrSceneMeshBuffersMSFT create(long address) {
        return new XrSceneMeshBuffersMSFT(address, null);
    }

    public static @Nullable XrSceneMeshBuffersMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneMeshBuffersMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSceneMeshBuffersMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneMeshBuffersMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneMeshBuffersMSFT malloc(MemoryStack stack) {
        return new XrSceneMeshBuffersMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneMeshBuffersMSFT calloc(MemoryStack stack) {
        return new XrSceneMeshBuffersMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSceneMeshBuffersMSFT.__struct(XrSceneMeshBuffersMSFT.__member(4), XrSceneMeshBuffersMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneMeshBuffersMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneMeshBuffersMSFT ELEMENT_FACTORY = XrSceneMeshBuffersMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSceneMeshBuffersMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneMeshBuffersMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneMeshBuffersMSFT.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneMeshBuffersMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097015);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneMeshBuffersMSFT.nnext(this.address(), value);
            return this;
        }
    }
}

