/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneObjectTypesFilterInfoMSFT
extends Struct<XrSceneObjectTypesFilterInfoMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int OBJECTTYPECOUNT;
    public static final int OBJECTTYPES;

    protected XrSceneObjectTypesFilterInfoMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSceneObjectTypesFilterInfoMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneObjectTypesFilterInfoMSFT(address, container);
    }

    public XrSceneObjectTypesFilterInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneObjectTypesFilterInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneObjectTypesFilterInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneObjectTypesFilterInfoMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int objectTypeCount() {
        return XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(this.address());
    }

    @NativeType(value="XrSceneObjectTypeMSFT const *")
    public @Nullable IntBuffer objectTypes() {
        return XrSceneObjectTypesFilterInfoMSFT.nobjectTypes(this.address());
    }

    public XrSceneObjectTypesFilterInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneObjectTypesFilterInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT type$Default() {
        return this.type(1000097010);
    }

    public XrSceneObjectTypesFilterInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSceneObjectTypesFilterInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT objectTypeCount(@NativeType(value="uint32_t") int value) {
        XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(this.address(), value);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT objectTypes(@NativeType(value="XrSceneObjectTypeMSFT const *") @Nullable IntBuffer value) {
        XrSceneObjectTypesFilterInfoMSFT.nobjectTypes(this.address(), value);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT set(int type, long next, int objectTypeCount, @Nullable IntBuffer objectTypes) {
        this.type(type);
        this.next(next);
        this.objectTypeCount(objectTypeCount);
        this.objectTypes(objectTypes);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT set(XrSceneObjectTypesFilterInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneObjectTypesFilterInfoMSFT malloc() {
        return new XrSceneObjectTypesFilterInfoMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSceneObjectTypesFilterInfoMSFT calloc() {
        return new XrSceneObjectTypesFilterInfoMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSceneObjectTypesFilterInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSceneObjectTypesFilterInfoMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrSceneObjectTypesFilterInfoMSFT create(long address) {
        return new XrSceneObjectTypesFilterInfoMSFT(address, null);
    }

    public static @Nullable XrSceneObjectTypesFilterInfoMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneObjectTypesFilterInfoMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSceneObjectTypesFilterInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneObjectTypesFilterInfoMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneObjectTypesFilterInfoMSFT malloc(MemoryStack stack) {
        return new XrSceneObjectTypesFilterInfoMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneObjectTypesFilterInfoMSFT calloc(MemoryStack stack) {
        return new XrSceneObjectTypesFilterInfoMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nobjectTypeCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OBJECTTYPECOUNT);
    }

    public static @Nullable IntBuffer nobjectTypes(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)OBJECTTYPES), XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nobjectTypeCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OBJECTTYPECOUNT, value);
    }

    public static void nobjectTypes(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)OBJECTTYPES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneObjectTypesFilterInfoMSFT.__struct(XrSceneObjectTypesFilterInfoMSFT.__member(4), XrSceneObjectTypesFilterInfoMSFT.__member(POINTER_SIZE), XrSceneObjectTypesFilterInfoMSFT.__member(4), XrSceneObjectTypesFilterInfoMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        OBJECTTYPECOUNT = layout.offsetof(2);
        OBJECTTYPES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneObjectTypesFilterInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneObjectTypesFilterInfoMSFT ELEMENT_FACTORY = XrSceneObjectTypesFilterInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSceneObjectTypesFilterInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneObjectTypesFilterInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneObjectTypesFilterInfoMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int objectTypeCount() {
            return XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(this.address());
        }

        @NativeType(value="XrSceneObjectTypeMSFT const *")
        public @Nullable IntBuffer objectTypes() {
            return XrSceneObjectTypesFilterInfoMSFT.nobjectTypes(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneObjectTypesFilterInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097010);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneObjectTypesFilterInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer objectTypeCount(@NativeType(value="uint32_t") int value) {
            XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(this.address(), value);
            return this;
        }

        public Buffer objectTypes(@NativeType(value="XrSceneObjectTypeMSFT const *") @Nullable IntBuffer value) {
            XrSceneObjectTypesFilterInfoMSFT.nobjectTypes(this.address(), value);
            return this;
        }
    }
}

