/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneObjectMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneObjectsMSFT
extends Struct<XrSceneObjectsMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SCENEOBJECTCOUNT;
    public static final int SCENEOBJECTS;

    protected XrSceneObjectsMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSceneObjectsMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneObjectsMSFT(address, container);
    }

    public XrSceneObjectsMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneObjectsMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneObjectsMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneObjectsMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int sceneObjectCount() {
        return XrSceneObjectsMSFT.nsceneObjectCount(this.address());
    }

    @NativeType(value="XrSceneObjectMSFT *")
    public @Nullable XrSceneObjectMSFT.Buffer sceneObjects() {
        return XrSceneObjectsMSFT.nsceneObjects(this.address());
    }

    public XrSceneObjectsMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneObjectsMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneObjectsMSFT type$Default() {
        return this.type(1000097008);
    }

    public XrSceneObjectsMSFT next(@NativeType(value="void *") long value) {
        XrSceneObjectsMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneObjectsMSFT sceneObjectCount(@NativeType(value="uint32_t") int value) {
        XrSceneObjectsMSFT.nsceneObjectCount(this.address(), value);
        return this;
    }

    public XrSceneObjectsMSFT sceneObjects(@NativeType(value="XrSceneObjectMSFT *") @Nullable XrSceneObjectMSFT.Buffer value) {
        XrSceneObjectsMSFT.nsceneObjects(this.address(), value);
        return this;
    }

    public XrSceneObjectsMSFT set(int type, long next, int sceneObjectCount, @Nullable XrSceneObjectMSFT.Buffer sceneObjects) {
        this.type(type);
        this.next(next);
        this.sceneObjectCount(sceneObjectCount);
        this.sceneObjects(sceneObjects);
        return this;
    }

    public XrSceneObjectsMSFT set(XrSceneObjectsMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneObjectsMSFT malloc() {
        return new XrSceneObjectsMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSceneObjectsMSFT calloc() {
        return new XrSceneObjectsMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSceneObjectsMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSceneObjectsMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrSceneObjectsMSFT create(long address) {
        return new XrSceneObjectsMSFT(address, null);
    }

    public static @Nullable XrSceneObjectsMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneObjectsMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSceneObjectsMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneObjectsMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneObjectsMSFT malloc(MemoryStack stack) {
        return new XrSceneObjectsMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneObjectsMSFT calloc(MemoryStack stack) {
        return new XrSceneObjectsMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsceneObjectCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SCENEOBJECTCOUNT);
    }

    public static @Nullable XrSceneObjectMSFT.Buffer nsceneObjects(long struct) {
        return XrSceneObjectMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)SCENEOBJECTS), XrSceneObjectsMSFT.nsceneObjectCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsceneObjectCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SCENEOBJECTCOUNT, value);
    }

    public static void nsceneObjects(long struct, @Nullable XrSceneObjectMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)SCENEOBJECTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneObjectsMSFT.nsceneObjectCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneObjectsMSFT.__struct(XrSceneObjectsMSFT.__member(4), XrSceneObjectsMSFT.__member(POINTER_SIZE), XrSceneObjectsMSFT.__member(4), XrSceneObjectsMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SCENEOBJECTCOUNT = layout.offsetof(2);
        SCENEOBJECTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneObjectsMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneObjectsMSFT ELEMENT_FACTORY = XrSceneObjectsMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSceneObjectsMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneObjectsMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneObjectsMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int sceneObjectCount() {
            return XrSceneObjectsMSFT.nsceneObjectCount(this.address());
        }

        @NativeType(value="XrSceneObjectMSFT *")
        public @Nullable XrSceneObjectMSFT.Buffer sceneObjects() {
            return XrSceneObjectsMSFT.nsceneObjects(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneObjectsMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097008);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneObjectsMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer sceneObjectCount(@NativeType(value="uint32_t") int value) {
            XrSceneObjectsMSFT.nsceneObjectCount(this.address(), value);
            return this;
        }

        public Buffer sceneObjects(@NativeType(value="XrSceneObjectMSFT *") @Nullable XrSceneObjectMSFT.Buffer value) {
            XrSceneObjectsMSFT.nsceneObjects(this.address(), value);
            return this;
        }
    }
}

