/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneObserverCreateInfoMSFT
extends Struct<XrSceneObserverCreateInfoMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrSceneObserverCreateInfoMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSceneObserverCreateInfoMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneObserverCreateInfoMSFT(address, container);
    }

    public XrSceneObserverCreateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneObserverCreateInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneObserverCreateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneObserverCreateInfoMSFT.nnext(this.address());
    }

    public XrSceneObserverCreateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneObserverCreateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneObserverCreateInfoMSFT type$Default() {
        return this.type(1000097000);
    }

    public XrSceneObserverCreateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSceneObserverCreateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneObserverCreateInfoMSFT set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSceneObserverCreateInfoMSFT set(XrSceneObserverCreateInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneObserverCreateInfoMSFT malloc() {
        return new XrSceneObserverCreateInfoMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSceneObserverCreateInfoMSFT calloc() {
        return new XrSceneObserverCreateInfoMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSceneObserverCreateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSceneObserverCreateInfoMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrSceneObserverCreateInfoMSFT create(long address) {
        return new XrSceneObserverCreateInfoMSFT(address, null);
    }

    public static @Nullable XrSceneObserverCreateInfoMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneObserverCreateInfoMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSceneObserverCreateInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneObserverCreateInfoMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneObserverCreateInfoMSFT malloc(MemoryStack stack) {
        return new XrSceneObserverCreateInfoMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneObserverCreateInfoMSFT calloc(MemoryStack stack) {
        return new XrSceneObserverCreateInfoMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSceneObserverCreateInfoMSFT.__struct(XrSceneObserverCreateInfoMSFT.__member(4), XrSceneObserverCreateInfoMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneObserverCreateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneObserverCreateInfoMSFT ELEMENT_FACTORY = XrSceneObserverCreateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSceneObserverCreateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneObserverCreateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneObserverCreateInfoMSFT.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneObserverCreateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneObserverCreateInfoMSFT.nnext(this.address(), value);
            return this;
        }
    }
}

