/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSemanticLabelsSupportInfoFB
extends Struct<XrSemanticLabelsSupportInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FLAGS;
    public static final int RECOGNIZEDLABELS;

    protected XrSemanticLabelsSupportInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSemanticLabelsSupportInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSemanticLabelsSupportInfoFB(address, container);
    }

    public XrSemanticLabelsSupportInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSemanticLabelsSupportInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSemanticLabelsSupportInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSemanticLabelsSupportInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSemanticLabelsSupportFlagsFB")
    public long flags() {
        return XrSemanticLabelsSupportInfoFB.nflags(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer recognizedLabels() {
        return XrSemanticLabelsSupportInfoFB.nrecognizedLabels(this.address());
    }

    @NativeType(value="char const *")
    public String recognizedLabelsString() {
        return XrSemanticLabelsSupportInfoFB.nrecognizedLabelsString(this.address());
    }

    public XrSemanticLabelsSupportInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSemanticLabelsSupportInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSemanticLabelsSupportInfoFB type$Default() {
        return this.type(1000175010);
    }

    public XrSemanticLabelsSupportInfoFB next(@NativeType(value="void const *") long value) {
        XrSemanticLabelsSupportInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSemanticLabelsSupportInfoFB flags(@NativeType(value="XrSemanticLabelsSupportFlagsFB") long value) {
        XrSemanticLabelsSupportInfoFB.nflags(this.address(), value);
        return this;
    }

    public XrSemanticLabelsSupportInfoFB recognizedLabels(@NativeType(value="char const *") ByteBuffer value) {
        XrSemanticLabelsSupportInfoFB.nrecognizedLabels(this.address(), value);
        return this;
    }

    public XrSemanticLabelsSupportInfoFB set(int type, long next, long flags, ByteBuffer recognizedLabels) {
        this.type(type);
        this.next(next);
        this.flags(flags);
        this.recognizedLabels(recognizedLabels);
        return this;
    }

    public XrSemanticLabelsSupportInfoFB set(XrSemanticLabelsSupportInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSemanticLabelsSupportInfoFB malloc() {
        return new XrSemanticLabelsSupportInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSemanticLabelsSupportInfoFB calloc() {
        return new XrSemanticLabelsSupportInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSemanticLabelsSupportInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSemanticLabelsSupportInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSemanticLabelsSupportInfoFB create(long address) {
        return new XrSemanticLabelsSupportInfoFB(address, null);
    }

    public static @Nullable XrSemanticLabelsSupportInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSemanticLabelsSupportInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSemanticLabelsSupportInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSemanticLabelsSupportInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSemanticLabelsSupportInfoFB malloc(MemoryStack stack) {
        return new XrSemanticLabelsSupportInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSemanticLabelsSupportInfoFB calloc(MemoryStack stack) {
        return new XrSemanticLabelsSupportInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLAGS);
    }

    public static ByteBuffer nrecognizedLabels(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)RECOGNIZEDLABELS));
    }

    public static String nrecognizedLabelsString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)RECOGNIZEDLABELS));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FLAGS, value);
    }

    public static void nrecognizedLabels(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)RECOGNIZEDLABELS, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)RECOGNIZEDLABELS));
    }

    static {
        Struct.Layout layout = XrSemanticLabelsSupportInfoFB.__struct(XrSemanticLabelsSupportInfoFB.__member(4), XrSemanticLabelsSupportInfoFB.__member(POINTER_SIZE), XrSemanticLabelsSupportInfoFB.__member(8), XrSemanticLabelsSupportInfoFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RECOGNIZEDLABELS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSemanticLabelsSupportInfoFB, Buffer>
    implements NativeResource {
        private static final XrSemanticLabelsSupportInfoFB ELEMENT_FACTORY = XrSemanticLabelsSupportInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSemanticLabelsSupportInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSemanticLabelsSupportInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSemanticLabelsSupportInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSemanticLabelsSupportFlagsFB")
        public long flags() {
            return XrSemanticLabelsSupportInfoFB.nflags(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer recognizedLabels() {
            return XrSemanticLabelsSupportInfoFB.nrecognizedLabels(this.address());
        }

        @NativeType(value="char const *")
        public String recognizedLabelsString() {
            return XrSemanticLabelsSupportInfoFB.nrecognizedLabelsString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSemanticLabelsSupportInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000175010);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSemanticLabelsSupportInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrSemanticLabelsSupportFlagsFB") long value) {
            XrSemanticLabelsSupportInfoFB.nflags(this.address(), value);
            return this;
        }

        public Buffer recognizedLabels(@NativeType(value="char const *") ByteBuffer value) {
            XrSemanticLabelsSupportInfoFB.nrecognizedLabels(this.address(), value);
            return this;
        }
    }
}

