/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceComponentStatusFB
extends Struct<XrSpaceComponentStatusFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ENABLED;
    public static final int CHANGEPENDING;

    protected XrSpaceComponentStatusFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceComponentStatusFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceComponentStatusFB(address, container);
    }

    public XrSpaceComponentStatusFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceComponentStatusFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceComponentStatusFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSpaceComponentStatusFB.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean enabled() {
        return XrSpaceComponentStatusFB.nenabled(this.address()) != 0;
    }

    @NativeType(value="XrBool32")
    public boolean changePending() {
        return XrSpaceComponentStatusFB.nchangePending(this.address()) != 0;
    }

    public XrSpaceComponentStatusFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceComponentStatusFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceComponentStatusFB type$Default() {
        return this.type(1000113001);
    }

    public XrSpaceComponentStatusFB next(@NativeType(value="void *") long value) {
        XrSpaceComponentStatusFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceComponentStatusFB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSpaceComponentStatusFB set(XrSpaceComponentStatusFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceComponentStatusFB malloc() {
        return new XrSpaceComponentStatusFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceComponentStatusFB calloc() {
        return new XrSpaceComponentStatusFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceComponentStatusFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceComponentStatusFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceComponentStatusFB create(long address) {
        return new XrSpaceComponentStatusFB(address, null);
    }

    public static @Nullable XrSpaceComponentStatusFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceComponentStatusFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceComponentStatusFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceComponentStatusFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceComponentStatusFB malloc(MemoryStack stack) {
        return new XrSpaceComponentStatusFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceComponentStatusFB calloc(MemoryStack stack) {
        return new XrSpaceComponentStatusFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nenabled(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENABLED);
    }

    public static int nchangePending(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CHANGEPENDING);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSpaceComponentStatusFB.__struct(XrSpaceComponentStatusFB.__member(4), XrSpaceComponentStatusFB.__member(POINTER_SIZE), XrSpaceComponentStatusFB.__member(4), XrSpaceComponentStatusFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ENABLED = layout.offsetof(2);
        CHANGEPENDING = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceComponentStatusFB, Buffer>
    implements NativeResource {
        private static final XrSpaceComponentStatusFB ELEMENT_FACTORY = XrSpaceComponentStatusFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceComponentStatusFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceComponentStatusFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSpaceComponentStatusFB.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean enabled() {
            return XrSpaceComponentStatusFB.nenabled(this.address()) != 0;
        }

        @NativeType(value="XrBool32")
        public boolean changePending() {
            return XrSpaceComponentStatusFB.nchangePending(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceComponentStatusFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000113001);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSpaceComponentStatusFB.nnext(this.address(), value);
            return this;
        }
    }
}

