/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceComponentFilterInfoFB;
import org.lwjgl.openxr.XrSpaceStorageLocationFilterInfoFB;
import org.lwjgl.openxr.XrSpaceUuidFilterInfoFB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceFilterInfoBaseHeaderFB
extends Struct<XrSpaceFilterInfoBaseHeaderFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrSpaceFilterInfoBaseHeaderFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceFilterInfoBaseHeaderFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceFilterInfoBaseHeaderFB(address, container);
    }

    public XrSpaceFilterInfoBaseHeaderFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceFilterInfoBaseHeaderFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceFilterInfoBaseHeaderFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceFilterInfoBaseHeaderFB.nnext(this.address());
    }

    public XrSpaceFilterInfoBaseHeaderFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceFilterInfoBaseHeaderFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceFilterInfoBaseHeaderFB next(@NativeType(value="void const *") long value) {
        XrSpaceFilterInfoBaseHeaderFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceFilterInfoBaseHeaderFB next(XrSpaceStorageLocationFilterInfoFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSpaceFilterInfoBaseHeaderFB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSpaceFilterInfoBaseHeaderFB set(XrSpaceFilterInfoBaseHeaderFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceFilterInfoBaseHeaderFB malloc() {
        return new XrSpaceFilterInfoBaseHeaderFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceFilterInfoBaseHeaderFB calloc() {
        return new XrSpaceFilterInfoBaseHeaderFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceFilterInfoBaseHeaderFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceFilterInfoBaseHeaderFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceFilterInfoBaseHeaderFB create(long address) {
        return new XrSpaceFilterInfoBaseHeaderFB(address, null);
    }

    public static @Nullable XrSpaceFilterInfoBaseHeaderFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceFilterInfoBaseHeaderFB(address, null);
    }

    public static XrSpaceFilterInfoBaseHeaderFB create(XrSpaceUuidFilterInfoFB value) {
        return new XrSpaceFilterInfoBaseHeaderFB(value.address(), XrSpaceFilterInfoBaseHeaderFB.__getContainer(value));
    }

    public static XrSpaceFilterInfoBaseHeaderFB create(XrSpaceComponentFilterInfoFB value) {
        return new XrSpaceFilterInfoBaseHeaderFB(value.address(), XrSpaceFilterInfoBaseHeaderFB.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceFilterInfoBaseHeaderFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceFilterInfoBaseHeaderFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrSpaceUuidFilterInfoFB.Buffer value) {
        return new Buffer(value.address(), XrSpaceFilterInfoBaseHeaderFB.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrSpaceComponentFilterInfoFB.Buffer value) {
        return new Buffer(value.address(), XrSpaceFilterInfoBaseHeaderFB.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrSpaceFilterInfoBaseHeaderFB malloc(MemoryStack stack) {
        return new XrSpaceFilterInfoBaseHeaderFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceFilterInfoBaseHeaderFB calloc(MemoryStack stack) {
        return new XrSpaceFilterInfoBaseHeaderFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSpaceFilterInfoBaseHeaderFB.__struct(XrSpaceFilterInfoBaseHeaderFB.__member(4), XrSpaceFilterInfoBaseHeaderFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceFilterInfoBaseHeaderFB, Buffer>
    implements NativeResource {
        private static final XrSpaceFilterInfoBaseHeaderFB ELEMENT_FACTORY = XrSpaceFilterInfoBaseHeaderFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceFilterInfoBaseHeaderFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceFilterInfoBaseHeaderFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceFilterInfoBaseHeaderFB.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceFilterInfoBaseHeaderFB.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceFilterInfoBaseHeaderFB.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrSpaceStorageLocationFilterInfoFB value) {
            return this.next(value.next(this.next()).address());
        }
    }
}

