/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceListSaveInfoFB
extends Struct<XrSpaceListSaveInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACECOUNT;
    public static final int SPACES;
    public static final int LOCATION;

    protected XrSpaceListSaveInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceListSaveInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceListSaveInfoFB(address, container);
    }

    public XrSpaceListSaveInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceListSaveInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceListSaveInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceListSaveInfoFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int spaceCount() {
        return XrSpaceListSaveInfoFB.nspaceCount(this.address());
    }

    @NativeType(value="XrSpace *")
    public PointerBuffer spaces() {
        return XrSpaceListSaveInfoFB.nspaces(this.address());
    }

    @NativeType(value="XrSpaceStorageLocationFB")
    public int location() {
        return XrSpaceListSaveInfoFB.nlocation(this.address());
    }

    public XrSpaceListSaveInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceListSaveInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceListSaveInfoFB type$Default() {
        return this.type(1000238000);
    }

    public XrSpaceListSaveInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceListSaveInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceListSaveInfoFB spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
        XrSpaceListSaveInfoFB.nspaces(this.address(), value);
        return this;
    }

    public XrSpaceListSaveInfoFB location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
        XrSpaceListSaveInfoFB.nlocation(this.address(), value);
        return this;
    }

    public XrSpaceListSaveInfoFB set(int type, long next, PointerBuffer spaces, int location) {
        this.type(type);
        this.next(next);
        this.spaces(spaces);
        this.location(location);
        return this;
    }

    public XrSpaceListSaveInfoFB set(XrSpaceListSaveInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceListSaveInfoFB malloc() {
        return new XrSpaceListSaveInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceListSaveInfoFB calloc() {
        return new XrSpaceListSaveInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceListSaveInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceListSaveInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceListSaveInfoFB create(long address) {
        return new XrSpaceListSaveInfoFB(address, null);
    }

    public static @Nullable XrSpaceListSaveInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceListSaveInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceListSaveInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceListSaveInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceListSaveInfoFB malloc(MemoryStack stack) {
        return new XrSpaceListSaveInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceListSaveInfoFB calloc(MemoryStack stack) {
        return new XrSpaceListSaveInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nspaceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPACECOUNT);
    }

    public static PointerBuffer nspaces(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)SPACES), XrSpaceListSaveInfoFB.nspaceCount(struct));
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOCATION);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nspaceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPACECOUNT, value);
    }

    public static void nspaces(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SPACES, MemoryUtil.memAddress(value));
        XrSpaceListSaveInfoFB.nspaceCount(struct, value.remaining());
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOCATION, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACES));
    }

    static {
        Struct.Layout layout = XrSpaceListSaveInfoFB.__struct(XrSpaceListSaveInfoFB.__member(4), XrSpaceListSaveInfoFB.__member(POINTER_SIZE), XrSpaceListSaveInfoFB.__member(4), XrSpaceListSaveInfoFB.__member(POINTER_SIZE), XrSpaceListSaveInfoFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACECOUNT = layout.offsetof(2);
        SPACES = layout.offsetof(3);
        LOCATION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceListSaveInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceListSaveInfoFB ELEMENT_FACTORY = XrSpaceListSaveInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceListSaveInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceListSaveInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceListSaveInfoFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int spaceCount() {
            return XrSpaceListSaveInfoFB.nspaceCount(this.address());
        }

        @NativeType(value="XrSpace *")
        public PointerBuffer spaces() {
            return XrSpaceListSaveInfoFB.nspaces(this.address());
        }

        @NativeType(value="XrSpaceStorageLocationFB")
        public int location() {
            return XrSpaceListSaveInfoFB.nlocation(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceListSaveInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000238000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceListSaveInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
            XrSpaceListSaveInfoFB.nspaces(this.address(), value);
            return this;
        }

        public Buffer location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
            XrSpaceListSaveInfoFB.nlocation(this.address(), value);
            return this;
        }
    }
}

