/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceLocationData
extends Struct<XrSpaceLocationData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATIONFLAGS;
    public static final int POSE;

    protected XrSpaceLocationData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceLocationData create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceLocationData(address, container);
    }

    public XrSpaceLocationData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceLocationData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long locationFlags() {
        return XrSpaceLocationData.nlocationFlags(this.address());
    }

    public XrPosef pose() {
        return XrSpaceLocationData.npose(this.address());
    }

    public static XrSpaceLocationData malloc() {
        return new XrSpaceLocationData(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceLocationData calloc() {
        return new XrSpaceLocationData(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceLocationData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceLocationData(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceLocationData create(long address) {
        return new XrSpaceLocationData(address, null);
    }

    public static @Nullable XrSpaceLocationData createSafe(long address) {
        return address == 0L ? null : new XrSpaceLocationData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceLocationData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceLocationData.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceLocationData malloc(MemoryStack stack) {
        return new XrSpaceLocationData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceLocationData calloc(MemoryStack stack) {
        return new XrSpaceLocationData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlocationFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LOCATIONFLAGS);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    static {
        Struct.Layout layout = XrSpaceLocationData.__struct(XrSpaceLocationData.__member(8), XrSpaceLocationData.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATIONFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceLocationData, Buffer>
    implements NativeResource {
        private static final XrSpaceLocationData ELEMENT_FACTORY = XrSpaceLocationData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceLocationData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long locationFlags() {
            return XrSpaceLocationData.nlocationFlags(this.address());
        }

        public XrPosef pose() {
            return XrSpaceLocationData.npose(this.address());
        }
    }
}

