/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceQueryResultFB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceQueryResultsFB
extends Struct<XrSpaceQueryResultsFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int RESULTCAPACITYINPUT;
    public static final int RESULTCOUNTOUTPUT;
    public static final int RESULTS;

    protected XrSpaceQueryResultsFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceQueryResultsFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceQueryResultsFB(address, container);
    }

    public XrSpaceQueryResultsFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceQueryResultsFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceQueryResultsFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSpaceQueryResultsFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int resultCapacityInput() {
        return XrSpaceQueryResultsFB.nresultCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int resultCountOutput() {
        return XrSpaceQueryResultsFB.nresultCountOutput(this.address());
    }

    @NativeType(value="XrSpaceQueryResultFB *")
    public @Nullable XrSpaceQueryResultFB.Buffer results() {
        return XrSpaceQueryResultsFB.nresults(this.address());
    }

    public XrSpaceQueryResultsFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceQueryResultsFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceQueryResultsFB type$Default() {
        return this.type(1000156002);
    }

    public XrSpaceQueryResultsFB next(@NativeType(value="void *") long value) {
        XrSpaceQueryResultsFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceQueryResultsFB resultCapacityInput(@NativeType(value="uint32_t") int value) {
        XrSpaceQueryResultsFB.nresultCapacityInput(this.address(), value);
        return this;
    }

    public XrSpaceQueryResultsFB resultCountOutput(@NativeType(value="uint32_t") int value) {
        XrSpaceQueryResultsFB.nresultCountOutput(this.address(), value);
        return this;
    }

    public XrSpaceQueryResultsFB results(@NativeType(value="XrSpaceQueryResultFB *") @Nullable XrSpaceQueryResultFB.Buffer value) {
        XrSpaceQueryResultsFB.nresults(this.address(), value);
        return this;
    }

    public XrSpaceQueryResultsFB set(int type, long next, int resultCapacityInput, int resultCountOutput, @Nullable XrSpaceQueryResultFB.Buffer results) {
        this.type(type);
        this.next(next);
        this.resultCapacityInput(resultCapacityInput);
        this.resultCountOutput(resultCountOutput);
        this.results(results);
        return this;
    }

    public XrSpaceQueryResultsFB set(XrSpaceQueryResultsFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceQueryResultsFB malloc() {
        return new XrSpaceQueryResultsFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceQueryResultsFB calloc() {
        return new XrSpaceQueryResultsFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceQueryResultsFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceQueryResultsFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceQueryResultsFB create(long address) {
        return new XrSpaceQueryResultsFB(address, null);
    }

    public static @Nullable XrSpaceQueryResultsFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceQueryResultsFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceQueryResultsFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceQueryResultsFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceQueryResultsFB malloc(MemoryStack stack) {
        return new XrSpaceQueryResultsFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceQueryResultsFB calloc(MemoryStack stack) {
        return new XrSpaceQueryResultsFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nresultCapacityInput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESULTCAPACITYINPUT);
    }

    public static int nresultCountOutput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESULTCOUNTOUTPUT);
    }

    public static @Nullable XrSpaceQueryResultFB.Buffer nresults(long struct) {
        return XrSpaceQueryResultFB.createSafe(MemoryUtil.memGetAddress(struct + (long)RESULTS), XrSpaceQueryResultsFB.nresultCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nresultCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESULTCAPACITYINPUT, value);
    }

    public static void nresultCountOutput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESULTCOUNTOUTPUT, value);
    }

    public static void nresults(long struct, @Nullable XrSpaceQueryResultFB.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)RESULTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSpaceQueryResultsFB.nresultCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSpaceQueryResultsFB.__struct(XrSpaceQueryResultsFB.__member(4), XrSpaceQueryResultsFB.__member(POINTER_SIZE), XrSpaceQueryResultsFB.__member(4), XrSpaceQueryResultsFB.__member(4), XrSpaceQueryResultsFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        RESULTCAPACITYINPUT = layout.offsetof(2);
        RESULTCOUNTOUTPUT = layout.offsetof(3);
        RESULTS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceQueryResultsFB, Buffer>
    implements NativeResource {
        private static final XrSpaceQueryResultsFB ELEMENT_FACTORY = XrSpaceQueryResultsFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceQueryResultsFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceQueryResultsFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSpaceQueryResultsFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int resultCapacityInput() {
            return XrSpaceQueryResultsFB.nresultCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int resultCountOutput() {
            return XrSpaceQueryResultsFB.nresultCountOutput(this.address());
        }

        @NativeType(value="XrSpaceQueryResultFB *")
        public @Nullable XrSpaceQueryResultFB.Buffer results() {
            return XrSpaceQueryResultsFB.nresults(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceQueryResultsFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000156002);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSpaceQueryResultsFB.nnext(this.address(), value);
            return this;
        }

        public Buffer resultCapacityInput(@NativeType(value="uint32_t") int value) {
            XrSpaceQueryResultsFB.nresultCapacityInput(this.address(), value);
            return this;
        }

        public Buffer resultCountOutput(@NativeType(value="uint32_t") int value) {
            XrSpaceQueryResultsFB.nresultCountOutput(this.address(), value);
            return this;
        }

        public Buffer results(@NativeType(value="XrSpaceQueryResultFB *") @Nullable XrSpaceQueryResultFB.Buffer value) {
            XrSpaceQueryResultsFB.nresults(this.address(), value);
            return this;
        }
    }
}

