/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceSaveInfoFB
extends Struct<XrSpaceSaveInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int LOCATION;
    public static final int PERSISTENCEMODE;

    protected XrSpaceSaveInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceSaveInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceSaveInfoFB(address, container);
    }

    public XrSpaceSaveInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceSaveInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceSaveInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceSaveInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSpaceSaveInfoFB.nspace(this.address());
    }

    @NativeType(value="XrSpaceStorageLocationFB")
    public int location() {
        return XrSpaceSaveInfoFB.nlocation(this.address());
    }

    @NativeType(value="XrSpacePersistenceModeFB")
    public int persistenceMode() {
        return XrSpaceSaveInfoFB.npersistenceMode(this.address());
    }

    public XrSpaceSaveInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceSaveInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB type$Default() {
        return this.type(1000158000);
    }

    public XrSpaceSaveInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceSaveInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB space(XrSpace value) {
        XrSpaceSaveInfoFB.nspace(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
        XrSpaceSaveInfoFB.nlocation(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB persistenceMode(@NativeType(value="XrSpacePersistenceModeFB") int value) {
        XrSpaceSaveInfoFB.npersistenceMode(this.address(), value);
        return this;
    }

    public XrSpaceSaveInfoFB set(int type, long next, XrSpace space, int location, int persistenceMode) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.location(location);
        this.persistenceMode(persistenceMode);
        return this;
    }

    public XrSpaceSaveInfoFB set(XrSpaceSaveInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceSaveInfoFB malloc() {
        return new XrSpaceSaveInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceSaveInfoFB calloc() {
        return new XrSpaceSaveInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceSaveInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceSaveInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceSaveInfoFB create(long address) {
        return new XrSpaceSaveInfoFB(address, null);
    }

    public static @Nullable XrSpaceSaveInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceSaveInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceSaveInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceSaveInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceSaveInfoFB malloc(MemoryStack stack) {
        return new XrSpaceSaveInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceSaveInfoFB calloc(MemoryStack stack) {
        return new XrSpaceSaveInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOCATION);
    }

    public static int npersistenceMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PERSISTENCEMODE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOCATION, value);
    }

    public static void npersistenceMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PERSISTENCEMODE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
    }

    static {
        Struct.Layout layout = XrSpaceSaveInfoFB.__struct(XrSpaceSaveInfoFB.__member(4), XrSpaceSaveInfoFB.__member(POINTER_SIZE), XrSpaceSaveInfoFB.__member(POINTER_SIZE), XrSpaceSaveInfoFB.__member(4), XrSpaceSaveInfoFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        LOCATION = layout.offsetof(3);
        PERSISTENCEMODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceSaveInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceSaveInfoFB ELEMENT_FACTORY = XrSpaceSaveInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceSaveInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceSaveInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceSaveInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSpaceSaveInfoFB.nspace(this.address());
        }

        @NativeType(value="XrSpaceStorageLocationFB")
        public int location() {
            return XrSpaceSaveInfoFB.nlocation(this.address());
        }

        @NativeType(value="XrSpacePersistenceModeFB")
        public int persistenceMode() {
            return XrSpaceSaveInfoFB.npersistenceMode(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceSaveInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000158000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceSaveInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrSpaceSaveInfoFB.nspace(this.address(), value);
            return this;
        }

        public Buffer location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
            XrSpaceSaveInfoFB.nlocation(this.address(), value);
            return this;
        }

        public Buffer persistenceMode(@NativeType(value="XrSpacePersistenceModeFB") int value) {
            XrSpaceSaveInfoFB.npersistenceMode(this.address(), value);
            return this;
        }
    }
}

