/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceVelocities;
import org.lwjgl.openxr.XrSpaceVelocityData;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class XrSpaceVelocitiesKHR
extends XrSpaceVelocities {
    protected XrSpaceVelocitiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceVelocitiesKHR create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceVelocitiesKHR(address, container);
    }

    public XrSpaceVelocitiesKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrSpaceVelocitiesKHR type(@NativeType(value="XrStructureType") int value) {
        XrSpaceVelocitiesKHR.ntype(this.address(), value);
        return this;
    }

    @Override
    public XrSpaceVelocitiesKHR type$Default() {
        return this.type(1000471002);
    }

    @Override
    public XrSpaceVelocitiesKHR next(@NativeType(value="void *") long value) {
        XrSpaceVelocitiesKHR.nnext(this.address(), value);
        return this;
    }

    @Override
    public XrSpaceVelocitiesKHR velocities(@NativeType(value="XrSpaceVelocityData *") XrSpaceVelocityData.Buffer value) {
        XrSpaceVelocitiesKHR.nvelocities(this.address(), value);
        return this;
    }

    @Override
    public XrSpaceVelocitiesKHR set(int type, long next, XrSpaceVelocityData.Buffer velocities) {
        this.type(type);
        this.next(next);
        this.velocities(velocities);
        return this;
    }

    public XrSpaceVelocitiesKHR set(XrSpaceVelocitiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceVelocitiesKHR malloc() {
        return new XrSpaceVelocitiesKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceVelocitiesKHR calloc() {
        return new XrSpaceVelocitiesKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceVelocitiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceVelocitiesKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceVelocitiesKHR create(long address) {
        return new XrSpaceVelocitiesKHR(address, null);
    }

    public static @Nullable XrSpaceVelocitiesKHR createSafe(long address) {
        return address == 0L ? null : new XrSpaceVelocitiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceVelocitiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceVelocitiesKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceVelocitiesKHR malloc(MemoryStack stack) {
        return new XrSpaceVelocitiesKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceVelocitiesKHR calloc(MemoryStack stack) {
        return new XrSpaceVelocitiesKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrSpaceVelocities.Buffer {
        private static final XrSpaceVelocitiesKHR ELEMENT_FACTORY = XrSpaceVelocitiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceVelocitiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceVelocitiesKHR.ntype(this.address(), value);
            return this;
        }

        @Override
        public Buffer type$Default() {
            return this.type(1000471002);
        }

        @Override
        public Buffer next(@NativeType(value="void *") long value) {
            XrSpaceVelocitiesKHR.nnext(this.address(), value);
            return this;
        }

        @Override
        public Buffer velocities(@NativeType(value="XrSpaceVelocityData *") XrSpaceVelocityData.Buffer value) {
            XrSpaceVelocitiesKHR.nvelocities(this.address(), value);
            return this;
        }
    }
}

