/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceVelocity
extends Struct<XrSpaceVelocity>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VELOCITYFLAGS;
    public static final int LINEARVELOCITY;
    public static final int ANGULARVELOCITY;

    protected XrSpaceVelocity(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceVelocity create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceVelocity(address, container);
    }

    public XrSpaceVelocity(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceVelocity.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceVelocity.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSpaceVelocity.nnext(this.address());
    }

    @NativeType(value="XrSpaceVelocityFlags")
    public long velocityFlags() {
        return XrSpaceVelocity.nvelocityFlags(this.address());
    }

    public XrVector3f linearVelocity() {
        return XrSpaceVelocity.nlinearVelocity(this.address());
    }

    public XrVector3f angularVelocity() {
        return XrSpaceVelocity.nangularVelocity(this.address());
    }

    public XrSpaceVelocity type(@NativeType(value="XrStructureType") int value) {
        XrSpaceVelocity.ntype(this.address(), value);
        return this;
    }

    public XrSpaceVelocity type$Default() {
        return this.type(43);
    }

    public XrSpaceVelocity next(@NativeType(value="void *") long value) {
        XrSpaceVelocity.nnext(this.address(), value);
        return this;
    }

    public XrSpaceVelocity velocityFlags(@NativeType(value="XrSpaceVelocityFlags") long value) {
        XrSpaceVelocity.nvelocityFlags(this.address(), value);
        return this;
    }

    public XrSpaceVelocity linearVelocity(XrVector3f value) {
        XrSpaceVelocity.nlinearVelocity(this.address(), value);
        return this;
    }

    public XrSpaceVelocity linearVelocity(Consumer<XrVector3f> consumer) {
        consumer.accept(this.linearVelocity());
        return this;
    }

    public XrSpaceVelocity angularVelocity(XrVector3f value) {
        XrSpaceVelocity.nangularVelocity(this.address(), value);
        return this;
    }

    public XrSpaceVelocity angularVelocity(Consumer<XrVector3f> consumer) {
        consumer.accept(this.angularVelocity());
        return this;
    }

    public XrSpaceVelocity set(int type, long next, long velocityFlags, XrVector3f linearVelocity, XrVector3f angularVelocity) {
        this.type(type);
        this.next(next);
        this.velocityFlags(velocityFlags);
        this.linearVelocity(linearVelocity);
        this.angularVelocity(angularVelocity);
        return this;
    }

    public XrSpaceVelocity set(XrSpaceVelocity src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceVelocity malloc() {
        return new XrSpaceVelocity(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceVelocity calloc() {
        return new XrSpaceVelocity(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceVelocity create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceVelocity(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceVelocity create(long address) {
        return new XrSpaceVelocity(address, null);
    }

    public static @Nullable XrSpaceVelocity createSafe(long address) {
        return address == 0L ? null : new XrSpaceVelocity(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceVelocity.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceVelocity.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceVelocity malloc(MemoryStack stack) {
        return new XrSpaceVelocity(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceVelocity calloc(MemoryStack stack) {
        return new XrSpaceVelocity(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nvelocityFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)VELOCITYFLAGS);
    }

    public static XrVector3f nlinearVelocity(long struct) {
        return XrVector3f.create(struct + (long)LINEARVELOCITY);
    }

    public static XrVector3f nangularVelocity(long struct) {
        return XrVector3f.create(struct + (long)ANGULARVELOCITY);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nvelocityFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)VELOCITYFLAGS, value);
    }

    public static void nlinearVelocity(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LINEARVELOCITY, XrVector3f.SIZEOF);
    }

    public static void nangularVelocity(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ANGULARVELOCITY, XrVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrSpaceVelocity.__struct(XrSpaceVelocity.__member(4), XrSpaceVelocity.__member(POINTER_SIZE), XrSpaceVelocity.__member(8), XrSpaceVelocity.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF), XrSpaceVelocity.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VELOCITYFLAGS = layout.offsetof(2);
        LINEARVELOCITY = layout.offsetof(3);
        ANGULARVELOCITY = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceVelocity, Buffer>
    implements NativeResource {
        private static final XrSpaceVelocity ELEMENT_FACTORY = XrSpaceVelocity.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceVelocity getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceVelocity.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSpaceVelocity.nnext(this.address());
        }

        @NativeType(value="XrSpaceVelocityFlags")
        public long velocityFlags() {
            return XrSpaceVelocity.nvelocityFlags(this.address());
        }

        public XrVector3f linearVelocity() {
            return XrSpaceVelocity.nlinearVelocity(this.address());
        }

        public XrVector3f angularVelocity() {
            return XrSpaceVelocity.nangularVelocity(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceVelocity.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(43);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSpaceVelocity.nnext(this.address(), value);
            return this;
        }

        public Buffer velocityFlags(@NativeType(value="XrSpaceVelocityFlags") long value) {
            XrSpaceVelocity.nvelocityFlags(this.address(), value);
            return this;
        }

        public Buffer linearVelocity(XrVector3f value) {
            XrSpaceVelocity.nlinearVelocity(this.address(), value);
            return this;
        }

        public Buffer linearVelocity(Consumer<XrVector3f> consumer) {
            consumer.accept(this.linearVelocity());
            return this;
        }

        public Buffer angularVelocity(XrVector3f value) {
            XrSpaceVelocity.nangularVelocity(this.address(), value);
            return this;
        }

        public Buffer angularVelocity(Consumer<XrVector3f> consumer) {
            consumer.accept(this.angularVelocity());
            return this;
        }
    }
}

