/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialAnchorCreateInfoFB
extends Struct<XrSpatialAnchorCreateInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int POSEINSPACE;
    public static final int TIME;

    protected XrSpatialAnchorCreateInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpatialAnchorCreateInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpatialAnchorCreateInfoFB(address, container);
    }

    public XrSpatialAnchorCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpatialAnchorCreateInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialAnchorCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpatialAnchorCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSpatialAnchorCreateInfoFB.nspace(this.address());
    }

    public XrPosef poseInSpace() {
        return XrSpatialAnchorCreateInfoFB.nposeInSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrSpatialAnchorCreateInfoFB.ntime(this.address());
    }

    public XrSpatialAnchorCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpatialAnchorCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoFB type$Default() {
        return this.type(1000113003);
    }

    public XrSpatialAnchorCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrSpatialAnchorCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoFB space(XrSpace value) {
        XrSpatialAnchorCreateInfoFB.nspace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoFB poseInSpace(XrPosef value) {
        XrSpatialAnchorCreateInfoFB.nposeInSpace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoFB poseInSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInSpace());
        return this;
    }

    public XrSpatialAnchorCreateInfoFB time(@NativeType(value="XrTime") long value) {
        XrSpatialAnchorCreateInfoFB.ntime(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoFB set(int type, long next, XrSpace space, XrPosef poseInSpace, long time) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.poseInSpace(poseInSpace);
        this.time(time);
        return this;
    }

    public XrSpatialAnchorCreateInfoFB set(XrSpatialAnchorCreateInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpatialAnchorCreateInfoFB malloc() {
        return new XrSpatialAnchorCreateInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoFB calloc() {
        return new XrSpatialAnchorCreateInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpatialAnchorCreateInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpatialAnchorCreateInfoFB create(long address) {
        return new XrSpatialAnchorCreateInfoFB(address, null);
    }

    public static @Nullable XrSpatialAnchorCreateInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSpatialAnchorCreateInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpatialAnchorCreateInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialAnchorCreateInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpatialAnchorCreateInfoFB malloc(MemoryStack stack) {
        return new XrSpatialAnchorCreateInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoFB calloc(MemoryStack stack) {
        return new XrSpatialAnchorCreateInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static XrPosef nposeInSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINSPACE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void nposeInSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINSPACE, XrPosef.SIZEOF);
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
    }

    static {
        Struct.Layout layout = XrSpatialAnchorCreateInfoFB.__struct(XrSpatialAnchorCreateInfoFB.__member(4), XrSpatialAnchorCreateInfoFB.__member(POINTER_SIZE), XrSpatialAnchorCreateInfoFB.__member(POINTER_SIZE), XrSpatialAnchorCreateInfoFB.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrSpatialAnchorCreateInfoFB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        POSEINSPACE = layout.offsetof(3);
        TIME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialAnchorCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpatialAnchorCreateInfoFB ELEMENT_FACTORY = XrSpatialAnchorCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpatialAnchorCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialAnchorCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpatialAnchorCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSpatialAnchorCreateInfoFB.nspace(this.address());
        }

        public XrPosef poseInSpace() {
            return XrSpatialAnchorCreateInfoFB.nposeInSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrSpatialAnchorCreateInfoFB.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialAnchorCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000113003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpatialAnchorCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrSpatialAnchorCreateInfoFB.nspace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(XrPosef value) {
            XrSpatialAnchorCreateInfoFB.nposeInSpace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInSpace());
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrSpatialAnchorCreateInfoFB.ntime(this.address(), value);
            return this;
        }
    }
}

