/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpatialAnchorNameHTC;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialAnchorCreateInfoHTC
extends Struct<XrSpatialAnchorCreateInfoHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int POSEINSPACE;
    public static final int NAME;

    protected XrSpatialAnchorCreateInfoHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpatialAnchorCreateInfoHTC create(long address, @Nullable ByteBuffer container) {
        return new XrSpatialAnchorCreateInfoHTC(address, container);
    }

    public XrSpatialAnchorCreateInfoHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpatialAnchorCreateInfoHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialAnchorCreateInfoHTC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpatialAnchorCreateInfoHTC.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSpatialAnchorCreateInfoHTC.nspace(this.address());
    }

    public XrPosef poseInSpace() {
        return XrSpatialAnchorCreateInfoHTC.nposeInSpace(this.address());
    }

    public XrSpatialAnchorNameHTC name() {
        return XrSpatialAnchorCreateInfoHTC.nname(this.address());
    }

    public XrSpatialAnchorCreateInfoHTC type(@NativeType(value="XrStructureType") int value) {
        XrSpatialAnchorCreateInfoHTC.ntype(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC type$Default() {
        return this.type(1000319001);
    }

    public XrSpatialAnchorCreateInfoHTC next(@NativeType(value="void const *") long value) {
        XrSpatialAnchorCreateInfoHTC.nnext(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC space(XrSpace value) {
        XrSpatialAnchorCreateInfoHTC.nspace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC poseInSpace(XrPosef value) {
        XrSpatialAnchorCreateInfoHTC.nposeInSpace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC poseInSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInSpace());
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC name(XrSpatialAnchorNameHTC value) {
        XrSpatialAnchorCreateInfoHTC.nname(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC name(Consumer<XrSpatialAnchorNameHTC> consumer) {
        consumer.accept(this.name());
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC set(int type, long next, XrSpace space, XrPosef poseInSpace, XrSpatialAnchorNameHTC name) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.poseInSpace(poseInSpace);
        this.name(name);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC set(XrSpatialAnchorCreateInfoHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpatialAnchorCreateInfoHTC malloc() {
        return new XrSpatialAnchorCreateInfoHTC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoHTC calloc() {
        return new XrSpatialAnchorCreateInfoHTC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpatialAnchorCreateInfoHTC(MemoryUtil.memAddress(container), container);
    }

    public static XrSpatialAnchorCreateInfoHTC create(long address) {
        return new XrSpatialAnchorCreateInfoHTC(address, null);
    }

    public static @Nullable XrSpatialAnchorCreateInfoHTC createSafe(long address) {
        return address == 0L ? null : new XrSpatialAnchorCreateInfoHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpatialAnchorCreateInfoHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialAnchorCreateInfoHTC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpatialAnchorCreateInfoHTC malloc(MemoryStack stack) {
        return new XrSpatialAnchorCreateInfoHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoHTC calloc(MemoryStack stack) {
        return new XrSpatialAnchorCreateInfoHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static XrPosef nposeInSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINSPACE);
    }

    public static XrSpatialAnchorNameHTC nname(long struct) {
        return XrSpatialAnchorNameHTC.create(struct + (long)NAME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void nposeInSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINSPACE, XrPosef.SIZEOF);
    }

    public static void nname(long struct, XrSpatialAnchorNameHTC value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NAME, XrSpatialAnchorNameHTC.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
    }

    static {
        Struct.Layout layout = XrSpatialAnchorCreateInfoHTC.__struct(XrSpatialAnchorCreateInfoHTC.__member(4), XrSpatialAnchorCreateInfoHTC.__member(POINTER_SIZE), XrSpatialAnchorCreateInfoHTC.__member(POINTER_SIZE), XrSpatialAnchorCreateInfoHTC.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrSpatialAnchorCreateInfoHTC.__member(XrSpatialAnchorNameHTC.SIZEOF, XrSpatialAnchorNameHTC.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        POSEINSPACE = layout.offsetof(3);
        NAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialAnchorCreateInfoHTC, Buffer>
    implements NativeResource {
        private static final XrSpatialAnchorCreateInfoHTC ELEMENT_FACTORY = XrSpatialAnchorCreateInfoHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpatialAnchorCreateInfoHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialAnchorCreateInfoHTC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpatialAnchorCreateInfoHTC.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSpatialAnchorCreateInfoHTC.nspace(this.address());
        }

        public XrPosef poseInSpace() {
            return XrSpatialAnchorCreateInfoHTC.nposeInSpace(this.address());
        }

        public XrSpatialAnchorNameHTC name() {
            return XrSpatialAnchorCreateInfoHTC.nname(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialAnchorCreateInfoHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000319001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpatialAnchorCreateInfoHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrSpatialAnchorCreateInfoHTC.nspace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(XrPosef value) {
            XrSpatialAnchorCreateInfoHTC.nposeInSpace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInSpace());
            return this;
        }

        public Buffer name(XrSpatialAnchorNameHTC value) {
            XrSpatialAnchorCreateInfoHTC.nname(this.address(), value);
            return this;
        }

        public Buffer name(Consumer<XrSpatialAnchorNameHTC> consumer) {
            consumer.accept(this.name());
            return this;
        }
    }
}

