/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialAnchorStateML
extends Struct<XrSpatialAnchorStateML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CONFIDENCE;

    protected XrSpatialAnchorStateML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpatialAnchorStateML create(long address, @Nullable ByteBuffer container) {
        return new XrSpatialAnchorStateML(address, container);
    }

    public XrSpatialAnchorStateML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpatialAnchorStateML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialAnchorStateML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSpatialAnchorStateML.nnext(this.address());
    }

    @NativeType(value="XrSpatialAnchorConfidenceML")
    public int confidence() {
        return XrSpatialAnchorStateML.nconfidence(this.address());
    }

    public XrSpatialAnchorStateML type(@NativeType(value="XrStructureType") int value) {
        XrSpatialAnchorStateML.ntype(this.address(), value);
        return this;
    }

    public XrSpatialAnchorStateML type$Default() {
        return this.type(1000140002);
    }

    public XrSpatialAnchorStateML next(@NativeType(value="void *") long value) {
        XrSpatialAnchorStateML.nnext(this.address(), value);
        return this;
    }

    public XrSpatialAnchorStateML confidence(@NativeType(value="XrSpatialAnchorConfidenceML") int value) {
        XrSpatialAnchorStateML.nconfidence(this.address(), value);
        return this;
    }

    public XrSpatialAnchorStateML set(int type, long next, int confidence) {
        this.type(type);
        this.next(next);
        this.confidence(confidence);
        return this;
    }

    public XrSpatialAnchorStateML set(XrSpatialAnchorStateML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpatialAnchorStateML malloc() {
        return new XrSpatialAnchorStateML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpatialAnchorStateML calloc() {
        return new XrSpatialAnchorStateML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpatialAnchorStateML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpatialAnchorStateML(MemoryUtil.memAddress(container), container);
    }

    public static XrSpatialAnchorStateML create(long address) {
        return new XrSpatialAnchorStateML(address, null);
    }

    public static @Nullable XrSpatialAnchorStateML createSafe(long address) {
        return address == 0L ? null : new XrSpatialAnchorStateML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpatialAnchorStateML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialAnchorStateML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpatialAnchorStateML malloc(MemoryStack stack) {
        return new XrSpatialAnchorStateML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpatialAnchorStateML calloc(MemoryStack stack) {
        return new XrSpatialAnchorStateML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nconfidence(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONFIDENCE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nconfidence(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONFIDENCE, value);
    }

    static {
        Struct.Layout layout = XrSpatialAnchorStateML.__struct(XrSpatialAnchorStateML.__member(4), XrSpatialAnchorStateML.__member(POINTER_SIZE), XrSpatialAnchorStateML.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CONFIDENCE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialAnchorStateML, Buffer>
    implements NativeResource {
        private static final XrSpatialAnchorStateML ELEMENT_FACTORY = XrSpatialAnchorStateML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpatialAnchorStateML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialAnchorStateML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSpatialAnchorStateML.nnext(this.address());
        }

        @NativeType(value="XrSpatialAnchorConfidenceML")
        public int confidence() {
            return XrSpatialAnchorStateML.nconfidence(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialAnchorStateML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000140002);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSpatialAnchorStateML.nnext(this.address(), value);
            return this;
        }

        public Buffer confidence(@NativeType(value="XrSpatialAnchorConfidenceML") int value) {
            XrSpatialAnchorStateML.nconfidence(this.address(), value);
            return this;
        }
    }
}

