/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialAnchorsPublishInfoML
extends Struct<XrSpatialAnchorsPublishInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ANCHORCOUNT;
    public static final int ANCHORS;
    public static final int EXPIRATION;

    protected XrSpatialAnchorsPublishInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpatialAnchorsPublishInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrSpatialAnchorsPublishInfoML(address, container);
    }

    public XrSpatialAnchorsPublishInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpatialAnchorsPublishInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialAnchorsPublishInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpatialAnchorsPublishInfoML.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int anchorCount() {
        return XrSpatialAnchorsPublishInfoML.nanchorCount(this.address());
    }

    @NativeType(value="XrSpace const *")
    public PointerBuffer anchors() {
        return XrSpatialAnchorsPublishInfoML.nanchors(this.address());
    }

    @NativeType(value="uint64_t")
    public long expiration() {
        return XrSpatialAnchorsPublishInfoML.nexpiration(this.address());
    }

    public XrSpatialAnchorsPublishInfoML type(@NativeType(value="XrStructureType") int value) {
        XrSpatialAnchorsPublishInfoML.ntype(this.address(), value);
        return this;
    }

    public XrSpatialAnchorsPublishInfoML type$Default() {
        return this.type(1000141004);
    }

    public XrSpatialAnchorsPublishInfoML next(@NativeType(value="void const *") long value) {
        XrSpatialAnchorsPublishInfoML.nnext(this.address(), value);
        return this;
    }

    public XrSpatialAnchorsPublishInfoML anchors(@NativeType(value="XrSpace const *") PointerBuffer value) {
        XrSpatialAnchorsPublishInfoML.nanchors(this.address(), value);
        return this;
    }

    public XrSpatialAnchorsPublishInfoML expiration(@NativeType(value="uint64_t") long value) {
        XrSpatialAnchorsPublishInfoML.nexpiration(this.address(), value);
        return this;
    }

    public XrSpatialAnchorsPublishInfoML set(int type, long next, PointerBuffer anchors, long expiration) {
        this.type(type);
        this.next(next);
        this.anchors(anchors);
        this.expiration(expiration);
        return this;
    }

    public XrSpatialAnchorsPublishInfoML set(XrSpatialAnchorsPublishInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpatialAnchorsPublishInfoML malloc() {
        return new XrSpatialAnchorsPublishInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpatialAnchorsPublishInfoML calloc() {
        return new XrSpatialAnchorsPublishInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpatialAnchorsPublishInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpatialAnchorsPublishInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrSpatialAnchorsPublishInfoML create(long address) {
        return new XrSpatialAnchorsPublishInfoML(address, null);
    }

    public static @Nullable XrSpatialAnchorsPublishInfoML createSafe(long address) {
        return address == 0L ? null : new XrSpatialAnchorsPublishInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpatialAnchorsPublishInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialAnchorsPublishInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpatialAnchorsPublishInfoML malloc(MemoryStack stack) {
        return new XrSpatialAnchorsPublishInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpatialAnchorsPublishInfoML calloc(MemoryStack stack) {
        return new XrSpatialAnchorsPublishInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nanchorCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ANCHORCOUNT);
    }

    public static PointerBuffer nanchors(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)ANCHORS), XrSpatialAnchorsPublishInfoML.nanchorCount(struct));
    }

    public static long nexpiration(long struct) {
        return MemoryUtil.memGetLong(struct + (long)EXPIRATION);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nanchorCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ANCHORCOUNT, value);
    }

    public static void nanchors(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)ANCHORS, MemoryUtil.memAddress(value));
        XrSpatialAnchorsPublishInfoML.nanchorCount(struct, value.remaining());
    }

    public static void nexpiration(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)EXPIRATION, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ANCHORS));
    }

    static {
        Struct.Layout layout = XrSpatialAnchorsPublishInfoML.__struct(XrSpatialAnchorsPublishInfoML.__member(4), XrSpatialAnchorsPublishInfoML.__member(POINTER_SIZE), XrSpatialAnchorsPublishInfoML.__member(4), XrSpatialAnchorsPublishInfoML.__member(POINTER_SIZE), XrSpatialAnchorsPublishInfoML.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ANCHORCOUNT = layout.offsetof(2);
        ANCHORS = layout.offsetof(3);
        EXPIRATION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialAnchorsPublishInfoML, Buffer>
    implements NativeResource {
        private static final XrSpatialAnchorsPublishInfoML ELEMENT_FACTORY = XrSpatialAnchorsPublishInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpatialAnchorsPublishInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialAnchorsPublishInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpatialAnchorsPublishInfoML.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int anchorCount() {
            return XrSpatialAnchorsPublishInfoML.nanchorCount(this.address());
        }

        @NativeType(value="XrSpace const *")
        public PointerBuffer anchors() {
            return XrSpatialAnchorsPublishInfoML.nanchors(this.address());
        }

        @NativeType(value="uint64_t")
        public long expiration() {
            return XrSpatialAnchorsPublishInfoML.nexpiration(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialAnchorsPublishInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000141004);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpatialAnchorsPublishInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer anchors(@NativeType(value="XrSpace const *") PointerBuffer value) {
            XrSpatialAnchorsPublishInfoML.nanchors(this.address(), value);
            return this;
        }

        public Buffer expiration(@NativeType(value="uint64_t") long value) {
            XrSpatialAnchorsPublishInfoML.nexpiration(this.address(), value);
            return this;
        }
    }
}

