/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpheref
extends Struct<XrSpheref>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CENTER;
    public static final int RADIUS;

    protected XrSpheref(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpheref create(long address, @Nullable ByteBuffer container) {
        return new XrSpheref(address, container);
    }

    public XrSpheref(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpheref.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public XrPosef center() {
        return XrSpheref.ncenter(this.address());
    }

    public float radius() {
        return XrSpheref.nradius(this.address());
    }

    public XrSpheref center(XrPosef value) {
        XrSpheref.ncenter(this.address(), value);
        return this;
    }

    public XrSpheref center(Consumer<XrPosef> consumer) {
        consumer.accept(this.center());
        return this;
    }

    public XrSpheref radius(float value) {
        XrSpheref.nradius(this.address(), value);
        return this;
    }

    public XrSpheref set(XrPosef center, float radius) {
        this.center(center);
        this.radius(radius);
        return this;
    }

    public XrSpheref set(XrSpheref src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpheref malloc() {
        return new XrSpheref(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpheref calloc() {
        return new XrSpheref(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpheref create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpheref(MemoryUtil.memAddress(container), container);
    }

    public static XrSpheref create(long address) {
        return new XrSpheref(address, null);
    }

    public static @Nullable XrSpheref createSafe(long address) {
        return address == 0L ? null : new XrSpheref(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpheref.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpheref.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpheref malloc(MemoryStack stack) {
        return new XrSpheref(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpheref calloc(MemoryStack stack) {
        return new XrSpheref(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrPosef ncenter(long struct) {
        return XrPosef.create(struct + (long)CENTER);
    }

    public static float nradius(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)RADIUS);
    }

    public static void ncenter(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CENTER, XrPosef.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)RADIUS, value);
    }

    static {
        Struct.Layout layout = XrSpheref.__struct(XrSpheref.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrSpheref.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CENTER = layout.offsetof(0);
        RADIUS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSpheref, Buffer>
    implements NativeResource {
        private static final XrSpheref ELEMENT_FACTORY = XrSpheref.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpheref getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrPosef center() {
            return XrSpheref.ncenter(this.address());
        }

        public float radius() {
            return XrSpheref.nradius(this.address());
        }

        public Buffer center(XrPosef value) {
            XrSpheref.ncenter(this.address(), value);
            return this;
        }

        public Buffer center(Consumer<XrPosef> consumer) {
            consumer.accept(this.center());
            return this;
        }

        public Buffer radius(float value) {
            XrSpheref.nradius(this.address(), value);
            return this;
        }
    }
}

