/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSecondaryViewConfigurationSwapchainCreateInfoMSFT;
import org.lwjgl.openxr.XrSwapchainCreateInfoFoveationFB;
import org.lwjgl.openxr.XrVulkanSwapchainCreateInfoMETA;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSwapchainCreateInfo
extends Struct<XrSwapchainCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CREATEFLAGS;
    public static final int USAGEFLAGS;
    public static final int FORMAT;
    public static final int SAMPLECOUNT;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int FACECOUNT;
    public static final int ARRAYSIZE;
    public static final int MIPCOUNT;

    protected XrSwapchainCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSwapchainCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrSwapchainCreateInfo(address, container);
    }

    public XrSwapchainCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSwapchainCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSwapchainCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSwapchainCreateInfo.nnext(this.address());
    }

    @NativeType(value="XrSwapchainCreateFlags")
    public long createFlags() {
        return XrSwapchainCreateInfo.ncreateFlags(this.address());
    }

    @NativeType(value="XrSwapchainUsageFlags")
    public long usageFlags() {
        return XrSwapchainCreateInfo.nusageFlags(this.address());
    }

    @NativeType(value="int64_t")
    public long format() {
        return XrSwapchainCreateInfo.nformat(this.address());
    }

    @NativeType(value="uint32_t")
    public int sampleCount() {
        return XrSwapchainCreateInfo.nsampleCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int width() {
        return XrSwapchainCreateInfo.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return XrSwapchainCreateInfo.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int faceCount() {
        return XrSwapchainCreateInfo.nfaceCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int arraySize() {
        return XrSwapchainCreateInfo.narraySize(this.address());
    }

    @NativeType(value="uint32_t")
    public int mipCount() {
        return XrSwapchainCreateInfo.nmipCount(this.address());
    }

    public XrSwapchainCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrSwapchainCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo type$Default() {
        return this.type(9);
    }

    public XrSwapchainCreateInfo next(@NativeType(value="void const *") long value) {
        XrSwapchainCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo next(XrSecondaryViewConfigurationSwapchainCreateInfoMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSwapchainCreateInfo next(XrSwapchainCreateInfoFoveationFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSwapchainCreateInfo next(XrVulkanSwapchainCreateInfoMETA value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSwapchainCreateInfo createFlags(@NativeType(value="XrSwapchainCreateFlags") long value) {
        XrSwapchainCreateInfo.ncreateFlags(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo usageFlags(@NativeType(value="XrSwapchainUsageFlags") long value) {
        XrSwapchainCreateInfo.nusageFlags(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo format(@NativeType(value="int64_t") long value) {
        XrSwapchainCreateInfo.nformat(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo sampleCount(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nsampleCount(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo width(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nwidth(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo height(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nheight(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo faceCount(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nfaceCount(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo arraySize(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.narraySize(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo mipCount(@NativeType(value="uint32_t") int value) {
        XrSwapchainCreateInfo.nmipCount(this.address(), value);
        return this;
    }

    public XrSwapchainCreateInfo set(int type, long next, long createFlags, long usageFlags, long format, int sampleCount, int width, int height, int faceCount, int arraySize, int mipCount) {
        this.type(type);
        this.next(next);
        this.createFlags(createFlags);
        this.usageFlags(usageFlags);
        this.format(format);
        this.sampleCount(sampleCount);
        this.width(width);
        this.height(height);
        this.faceCount(faceCount);
        this.arraySize(arraySize);
        this.mipCount(mipCount);
        return this;
    }

    public XrSwapchainCreateInfo set(XrSwapchainCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSwapchainCreateInfo malloc() {
        return new XrSwapchainCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSwapchainCreateInfo calloc() {
        return new XrSwapchainCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSwapchainCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSwapchainCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static XrSwapchainCreateInfo create(long address) {
        return new XrSwapchainCreateInfo(address, null);
    }

    public static @Nullable XrSwapchainCreateInfo createSafe(long address) {
        return address == 0L ? null : new XrSwapchainCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSwapchainCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSwapchainCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSwapchainCreateInfo malloc(MemoryStack stack) {
        return new XrSwapchainCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSwapchainCreateInfo calloc(MemoryStack stack) {
        return new XrSwapchainCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ncreateFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CREATEFLAGS);
    }

    public static long nusageFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)USAGEFLAGS);
    }

    public static long nformat(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FORMAT);
    }

    public static int nsampleCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLECOUNT);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int nfaceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FACECOUNT);
    }

    public static int narraySize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ARRAYSIZE);
    }

    public static int nmipCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MIPCOUNT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncreateFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)CREATEFLAGS, value);
    }

    public static void nusageFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)USAGEFLAGS, value);
    }

    public static void nformat(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FORMAT, value);
    }

    public static void nsampleCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLECOUNT, value);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void nfaceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FACECOUNT, value);
    }

    public static void narraySize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ARRAYSIZE, value);
    }

    public static void nmipCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MIPCOUNT, value);
    }

    static {
        Struct.Layout layout = XrSwapchainCreateInfo.__struct(XrSwapchainCreateInfo.__member(4), XrSwapchainCreateInfo.__member(POINTER_SIZE), XrSwapchainCreateInfo.__member(8), XrSwapchainCreateInfo.__member(8), XrSwapchainCreateInfo.__member(8), XrSwapchainCreateInfo.__member(4), XrSwapchainCreateInfo.__member(4), XrSwapchainCreateInfo.__member(4), XrSwapchainCreateInfo.__member(4), XrSwapchainCreateInfo.__member(4), XrSwapchainCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CREATEFLAGS = layout.offsetof(2);
        USAGEFLAGS = layout.offsetof(3);
        FORMAT = layout.offsetof(4);
        SAMPLECOUNT = layout.offsetof(5);
        WIDTH = layout.offsetof(6);
        HEIGHT = layout.offsetof(7);
        FACECOUNT = layout.offsetof(8);
        ARRAYSIZE = layout.offsetof(9);
        MIPCOUNT = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<XrSwapchainCreateInfo, Buffer>
    implements NativeResource {
        private static final XrSwapchainCreateInfo ELEMENT_FACTORY = XrSwapchainCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSwapchainCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSwapchainCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSwapchainCreateInfo.nnext(this.address());
        }

        @NativeType(value="XrSwapchainCreateFlags")
        public long createFlags() {
            return XrSwapchainCreateInfo.ncreateFlags(this.address());
        }

        @NativeType(value="XrSwapchainUsageFlags")
        public long usageFlags() {
            return XrSwapchainCreateInfo.nusageFlags(this.address());
        }

        @NativeType(value="int64_t")
        public long format() {
            return XrSwapchainCreateInfo.nformat(this.address());
        }

        @NativeType(value="uint32_t")
        public int sampleCount() {
            return XrSwapchainCreateInfo.nsampleCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int width() {
            return XrSwapchainCreateInfo.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return XrSwapchainCreateInfo.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int faceCount() {
            return XrSwapchainCreateInfo.nfaceCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int arraySize() {
            return XrSwapchainCreateInfo.narraySize(this.address());
        }

        @NativeType(value="uint32_t")
        public int mipCount() {
            return XrSwapchainCreateInfo.nmipCount(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSwapchainCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(9);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSwapchainCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrSecondaryViewConfigurationSwapchainCreateInfoMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSwapchainCreateInfoFoveationFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrVulkanSwapchainCreateInfoMETA value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer createFlags(@NativeType(value="XrSwapchainCreateFlags") long value) {
            XrSwapchainCreateInfo.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer usageFlags(@NativeType(value="XrSwapchainUsageFlags") long value) {
            XrSwapchainCreateInfo.nusageFlags(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="int64_t") long value) {
            XrSwapchainCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer sampleCount(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nsampleCount(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nheight(this.address(), value);
            return this;
        }

        public Buffer faceCount(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nfaceCount(this.address(), value);
            return this;
        }

        public Buffer arraySize(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.narraySize(this.address(), value);
            return this;
        }

        public Buffer mipCount(@NativeType(value="uint32_t") int value) {
            XrSwapchainCreateInfo.nmipCount(this.address(), value);
            return this;
        }
    }
}

