/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSwapchainImageAcquireInfo
extends Struct<XrSwapchainImageAcquireInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrSwapchainImageAcquireInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSwapchainImageAcquireInfo create(long address, @Nullable ByteBuffer container) {
        return new XrSwapchainImageAcquireInfo(address, container);
    }

    public XrSwapchainImageAcquireInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSwapchainImageAcquireInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSwapchainImageAcquireInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSwapchainImageAcquireInfo.nnext(this.address());
    }

    public XrSwapchainImageAcquireInfo type(@NativeType(value="XrStructureType") int value) {
        XrSwapchainImageAcquireInfo.ntype(this.address(), value);
        return this;
    }

    public XrSwapchainImageAcquireInfo type$Default() {
        return this.type(55);
    }

    public XrSwapchainImageAcquireInfo next(@NativeType(value="void const *") long value) {
        XrSwapchainImageAcquireInfo.nnext(this.address(), value);
        return this;
    }

    public XrSwapchainImageAcquireInfo set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSwapchainImageAcquireInfo set(XrSwapchainImageAcquireInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSwapchainImageAcquireInfo malloc() {
        return new XrSwapchainImageAcquireInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSwapchainImageAcquireInfo calloc() {
        return new XrSwapchainImageAcquireInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSwapchainImageAcquireInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSwapchainImageAcquireInfo(MemoryUtil.memAddress(container), container);
    }

    public static XrSwapchainImageAcquireInfo create(long address) {
        return new XrSwapchainImageAcquireInfo(address, null);
    }

    public static @Nullable XrSwapchainImageAcquireInfo createSafe(long address) {
        return address == 0L ? null : new XrSwapchainImageAcquireInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSwapchainImageAcquireInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSwapchainImageAcquireInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSwapchainImageAcquireInfo malloc(MemoryStack stack) {
        return new XrSwapchainImageAcquireInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSwapchainImageAcquireInfo calloc(MemoryStack stack) {
        return new XrSwapchainImageAcquireInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSwapchainImageAcquireInfo.__struct(XrSwapchainImageAcquireInfo.__member(4), XrSwapchainImageAcquireInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSwapchainImageAcquireInfo, Buffer>
    implements NativeResource {
        private static final XrSwapchainImageAcquireInfo ELEMENT_FACTORY = XrSwapchainImageAcquireInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSwapchainImageAcquireInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSwapchainImageAcquireInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSwapchainImageAcquireInfo.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSwapchainImageAcquireInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(55);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSwapchainImageAcquireInfo.nnext(this.address(), value);
            return this;
        }
    }
}

