/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemAnchorPropertiesHTC
extends Struct<XrSystemAnchorPropertiesHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTSANCHOR;

    protected XrSystemAnchorPropertiesHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSystemAnchorPropertiesHTC create(long address, @Nullable ByteBuffer container) {
        return new XrSystemAnchorPropertiesHTC(address, container);
    }

    public XrSystemAnchorPropertiesHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemAnchorPropertiesHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemAnchorPropertiesHTC.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemAnchorPropertiesHTC.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsAnchor() {
        return XrSystemAnchorPropertiesHTC.nsupportsAnchor(this.address()) != 0;
    }

    public XrSystemAnchorPropertiesHTC type(@NativeType(value="XrStructureType") int value) {
        XrSystemAnchorPropertiesHTC.ntype(this.address(), value);
        return this;
    }

    public XrSystemAnchorPropertiesHTC type$Default() {
        return this.type(1000319000);
    }

    public XrSystemAnchorPropertiesHTC next(@NativeType(value="void *") long value) {
        XrSystemAnchorPropertiesHTC.nnext(this.address(), value);
        return this;
    }

    public XrSystemAnchorPropertiesHTC set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSystemAnchorPropertiesHTC set(XrSystemAnchorPropertiesHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemAnchorPropertiesHTC malloc() {
        return new XrSystemAnchorPropertiesHTC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSystemAnchorPropertiesHTC calloc() {
        return new XrSystemAnchorPropertiesHTC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSystemAnchorPropertiesHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSystemAnchorPropertiesHTC(MemoryUtil.memAddress(container), container);
    }

    public static XrSystemAnchorPropertiesHTC create(long address) {
        return new XrSystemAnchorPropertiesHTC(address, null);
    }

    public static @Nullable XrSystemAnchorPropertiesHTC createSafe(long address) {
        return address == 0L ? null : new XrSystemAnchorPropertiesHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSystemAnchorPropertiesHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemAnchorPropertiesHTC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemAnchorPropertiesHTC malloc(MemoryStack stack) {
        return new XrSystemAnchorPropertiesHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemAnchorPropertiesHTC calloc(MemoryStack stack) {
        return new XrSystemAnchorPropertiesHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsupportsAnchor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTSANCHOR);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSystemAnchorPropertiesHTC.__struct(XrSystemAnchorPropertiesHTC.__member(4), XrSystemAnchorPropertiesHTC.__member(POINTER_SIZE), XrSystemAnchorPropertiesHTC.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTSANCHOR = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemAnchorPropertiesHTC, Buffer>
    implements NativeResource {
        private static final XrSystemAnchorPropertiesHTC ELEMENT_FACTORY = XrSystemAnchorPropertiesHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSystemAnchorPropertiesHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemAnchorPropertiesHTC.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemAnchorPropertiesHTC.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsAnchor() {
            return XrSystemAnchorPropertiesHTC.nsupportsAnchor(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemAnchorPropertiesHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000319000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemAnchorPropertiesHTC.nnext(this.address(), value);
            return this;
        }
    }
}

