/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemBodyTrackingPropertiesFB
extends Struct<XrSystemBodyTrackingPropertiesFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTSBODYTRACKING;

    protected XrSystemBodyTrackingPropertiesFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSystemBodyTrackingPropertiesFB create(long address, @Nullable ByteBuffer container) {
        return new XrSystemBodyTrackingPropertiesFB(address, container);
    }

    public XrSystemBodyTrackingPropertiesFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemBodyTrackingPropertiesFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemBodyTrackingPropertiesFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemBodyTrackingPropertiesFB.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsBodyTracking() {
        return XrSystemBodyTrackingPropertiesFB.nsupportsBodyTracking(this.address()) != 0;
    }

    public XrSystemBodyTrackingPropertiesFB type(@NativeType(value="XrStructureType") int value) {
        XrSystemBodyTrackingPropertiesFB.ntype(this.address(), value);
        return this;
    }

    public XrSystemBodyTrackingPropertiesFB type$Default() {
        return this.type(1000076004);
    }

    public XrSystemBodyTrackingPropertiesFB next(@NativeType(value="void *") long value) {
        XrSystemBodyTrackingPropertiesFB.nnext(this.address(), value);
        return this;
    }

    public XrSystemBodyTrackingPropertiesFB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSystemBodyTrackingPropertiesFB set(XrSystemBodyTrackingPropertiesFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemBodyTrackingPropertiesFB malloc() {
        return new XrSystemBodyTrackingPropertiesFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSystemBodyTrackingPropertiesFB calloc() {
        return new XrSystemBodyTrackingPropertiesFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSystemBodyTrackingPropertiesFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSystemBodyTrackingPropertiesFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSystemBodyTrackingPropertiesFB create(long address) {
        return new XrSystemBodyTrackingPropertiesFB(address, null);
    }

    public static @Nullable XrSystemBodyTrackingPropertiesFB createSafe(long address) {
        return address == 0L ? null : new XrSystemBodyTrackingPropertiesFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSystemBodyTrackingPropertiesFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemBodyTrackingPropertiesFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemBodyTrackingPropertiesFB malloc(MemoryStack stack) {
        return new XrSystemBodyTrackingPropertiesFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemBodyTrackingPropertiesFB calloc(MemoryStack stack) {
        return new XrSystemBodyTrackingPropertiesFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsupportsBodyTracking(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTSBODYTRACKING);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSystemBodyTrackingPropertiesFB.__struct(XrSystemBodyTrackingPropertiesFB.__member(4), XrSystemBodyTrackingPropertiesFB.__member(POINTER_SIZE), XrSystemBodyTrackingPropertiesFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTSBODYTRACKING = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemBodyTrackingPropertiesFB, Buffer>
    implements NativeResource {
        private static final XrSystemBodyTrackingPropertiesFB ELEMENT_FACTORY = XrSystemBodyTrackingPropertiesFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSystemBodyTrackingPropertiesFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemBodyTrackingPropertiesFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemBodyTrackingPropertiesFB.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsBodyTracking() {
            return XrSystemBodyTrackingPropertiesFB.nsupportsBodyTracking(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemBodyTrackingPropertiesFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000076004);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemBodyTrackingPropertiesFB.nnext(this.address(), value);
            return this;
        }
    }
}

