/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemBodyTrackingPropertiesHTC
extends Struct<XrSystemBodyTrackingPropertiesHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTSBODYTRACKING;

    protected XrSystemBodyTrackingPropertiesHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSystemBodyTrackingPropertiesHTC create(long address, @Nullable ByteBuffer container) {
        return new XrSystemBodyTrackingPropertiesHTC(address, container);
    }

    public XrSystemBodyTrackingPropertiesHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemBodyTrackingPropertiesHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemBodyTrackingPropertiesHTC.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemBodyTrackingPropertiesHTC.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsBodyTracking() {
        return XrSystemBodyTrackingPropertiesHTC.nsupportsBodyTracking(this.address()) != 0;
    }

    public XrSystemBodyTrackingPropertiesHTC type(@NativeType(value="XrStructureType") int value) {
        XrSystemBodyTrackingPropertiesHTC.ntype(this.address(), value);
        return this;
    }

    public XrSystemBodyTrackingPropertiesHTC type$Default() {
        return this.type(1000320000);
    }

    public XrSystemBodyTrackingPropertiesHTC next(@NativeType(value="void *") long value) {
        XrSystemBodyTrackingPropertiesHTC.nnext(this.address(), value);
        return this;
    }

    public XrSystemBodyTrackingPropertiesHTC set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSystemBodyTrackingPropertiesHTC set(XrSystemBodyTrackingPropertiesHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemBodyTrackingPropertiesHTC malloc() {
        return new XrSystemBodyTrackingPropertiesHTC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSystemBodyTrackingPropertiesHTC calloc() {
        return new XrSystemBodyTrackingPropertiesHTC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSystemBodyTrackingPropertiesHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSystemBodyTrackingPropertiesHTC(MemoryUtil.memAddress(container), container);
    }

    public static XrSystemBodyTrackingPropertiesHTC create(long address) {
        return new XrSystemBodyTrackingPropertiesHTC(address, null);
    }

    public static @Nullable XrSystemBodyTrackingPropertiesHTC createSafe(long address) {
        return address == 0L ? null : new XrSystemBodyTrackingPropertiesHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSystemBodyTrackingPropertiesHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemBodyTrackingPropertiesHTC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemBodyTrackingPropertiesHTC malloc(MemoryStack stack) {
        return new XrSystemBodyTrackingPropertiesHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemBodyTrackingPropertiesHTC calloc(MemoryStack stack) {
        return new XrSystemBodyTrackingPropertiesHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsupportsBodyTracking(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTSBODYTRACKING);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSystemBodyTrackingPropertiesHTC.__struct(XrSystemBodyTrackingPropertiesHTC.__member(4), XrSystemBodyTrackingPropertiesHTC.__member(POINTER_SIZE), XrSystemBodyTrackingPropertiesHTC.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTSBODYTRACKING = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemBodyTrackingPropertiesHTC, Buffer>
    implements NativeResource {
        private static final XrSystemBodyTrackingPropertiesHTC ELEMENT_FACTORY = XrSystemBodyTrackingPropertiesHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSystemBodyTrackingPropertiesHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemBodyTrackingPropertiesHTC.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemBodyTrackingPropertiesHTC.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsBodyTracking() {
            return XrSystemBodyTrackingPropertiesHTC.nsupportsBodyTracking(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemBodyTrackingPropertiesHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000320000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemBodyTrackingPropertiesHTC.nnext(this.address(), value);
            return this;
        }
    }
}

