/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemPassthroughProperties2FB
extends Struct<XrSystemPassthroughProperties2FB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CAPABILITIES;

    protected XrSystemPassthroughProperties2FB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSystemPassthroughProperties2FB create(long address, @Nullable ByteBuffer container) {
        return new XrSystemPassthroughProperties2FB(address, container);
    }

    public XrSystemPassthroughProperties2FB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemPassthroughProperties2FB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemPassthroughProperties2FB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSystemPassthroughProperties2FB.nnext(this.address());
    }

    @NativeType(value="XrPassthroughCapabilityFlagsFB")
    public long capabilities() {
        return XrSystemPassthroughProperties2FB.ncapabilities(this.address());
    }

    public XrSystemPassthroughProperties2FB type(@NativeType(value="XrStructureType") int value) {
        XrSystemPassthroughProperties2FB.ntype(this.address(), value);
        return this;
    }

    public XrSystemPassthroughProperties2FB type$Default() {
        return this.type(1000118006);
    }

    public XrSystemPassthroughProperties2FB next(@NativeType(value="void const *") long value) {
        XrSystemPassthroughProperties2FB.nnext(this.address(), value);
        return this;
    }

    public XrSystemPassthroughProperties2FB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSystemPassthroughProperties2FB set(XrSystemPassthroughProperties2FB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemPassthroughProperties2FB malloc() {
        return new XrSystemPassthroughProperties2FB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSystemPassthroughProperties2FB calloc() {
        return new XrSystemPassthroughProperties2FB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSystemPassthroughProperties2FB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSystemPassthroughProperties2FB(MemoryUtil.memAddress(container), container);
    }

    public static XrSystemPassthroughProperties2FB create(long address) {
        return new XrSystemPassthroughProperties2FB(address, null);
    }

    public static @Nullable XrSystemPassthroughProperties2FB createSafe(long address) {
        return address == 0L ? null : new XrSystemPassthroughProperties2FB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSystemPassthroughProperties2FB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemPassthroughProperties2FB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemPassthroughProperties2FB malloc(MemoryStack stack) {
        return new XrSystemPassthroughProperties2FB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemPassthroughProperties2FB calloc(MemoryStack stack) {
        return new XrSystemPassthroughProperties2FB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ncapabilities(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CAPABILITIES);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSystemPassthroughProperties2FB.__struct(XrSystemPassthroughProperties2FB.__member(4), XrSystemPassthroughProperties2FB.__member(POINTER_SIZE), XrSystemPassthroughProperties2FB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CAPABILITIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemPassthroughProperties2FB, Buffer>
    implements NativeResource {
        private static final XrSystemPassthroughProperties2FB ELEMENT_FACTORY = XrSystemPassthroughProperties2FB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSystemPassthroughProperties2FB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemPassthroughProperties2FB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSystemPassthroughProperties2FB.nnext(this.address());
        }

        @NativeType(value="XrPassthroughCapabilityFlagsFB")
        public long capabilities() {
            return XrSystemPassthroughProperties2FB.ncapabilities(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemPassthroughProperties2FB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118006);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSystemPassthroughProperties2FB.nnext(this.address(), value);
            return this;
        }
    }
}

