/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemPlaneDetectionPropertiesEXT
extends Struct<XrSystemPlaneDetectionPropertiesEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTEDFEATURES;

    protected XrSystemPlaneDetectionPropertiesEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSystemPlaneDetectionPropertiesEXT create(long address, @Nullable ByteBuffer container) {
        return new XrSystemPlaneDetectionPropertiesEXT(address, container);
    }

    public XrSystemPlaneDetectionPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemPlaneDetectionPropertiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemPlaneDetectionPropertiesEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemPlaneDetectionPropertiesEXT.nnext(this.address());
    }

    @NativeType(value="XrPlaneDetectionCapabilityFlagsEXT")
    public long supportedFeatures() {
        return XrSystemPlaneDetectionPropertiesEXT.nsupportedFeatures(this.address());
    }

    public XrSystemPlaneDetectionPropertiesEXT type(@NativeType(value="XrStructureType") int value) {
        XrSystemPlaneDetectionPropertiesEXT.ntype(this.address(), value);
        return this;
    }

    public XrSystemPlaneDetectionPropertiesEXT type$Default() {
        return this.type(1000429007);
    }

    public XrSystemPlaneDetectionPropertiesEXT next(@NativeType(value="void *") long value) {
        XrSystemPlaneDetectionPropertiesEXT.nnext(this.address(), value);
        return this;
    }

    public XrSystemPlaneDetectionPropertiesEXT set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSystemPlaneDetectionPropertiesEXT set(XrSystemPlaneDetectionPropertiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemPlaneDetectionPropertiesEXT malloc() {
        return new XrSystemPlaneDetectionPropertiesEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSystemPlaneDetectionPropertiesEXT calloc() {
        return new XrSystemPlaneDetectionPropertiesEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSystemPlaneDetectionPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSystemPlaneDetectionPropertiesEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrSystemPlaneDetectionPropertiesEXT create(long address) {
        return new XrSystemPlaneDetectionPropertiesEXT(address, null);
    }

    public static @Nullable XrSystemPlaneDetectionPropertiesEXT createSafe(long address) {
        return address == 0L ? null : new XrSystemPlaneDetectionPropertiesEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSystemPlaneDetectionPropertiesEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemPlaneDetectionPropertiesEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemPlaneDetectionPropertiesEXT malloc(MemoryStack stack) {
        return new XrSystemPlaneDetectionPropertiesEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemPlaneDetectionPropertiesEXT calloc(MemoryStack stack) {
        return new XrSystemPlaneDetectionPropertiesEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nsupportedFeatures(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SUPPORTEDFEATURES);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSystemPlaneDetectionPropertiesEXT.__struct(XrSystemPlaneDetectionPropertiesEXT.__member(4), XrSystemPlaneDetectionPropertiesEXT.__member(POINTER_SIZE), XrSystemPlaneDetectionPropertiesEXT.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTEDFEATURES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemPlaneDetectionPropertiesEXT, Buffer>
    implements NativeResource {
        private static final XrSystemPlaneDetectionPropertiesEXT ELEMENT_FACTORY = XrSystemPlaneDetectionPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSystemPlaneDetectionPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemPlaneDetectionPropertiesEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemPlaneDetectionPropertiesEXT.nnext(this.address());
        }

        @NativeType(value="XrPlaneDetectionCapabilityFlagsEXT")
        public long supportedFeatures() {
            return XrSystemPlaneDetectionPropertiesEXT.nsupportedFeatures(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemPlaneDetectionPropertiesEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000429007);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemPlaneDetectionPropertiesEXT.nnext(this.address(), value);
            return this;
        }
    }
}

