/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVirtualKeyboardLocationInfoMETA
extends Struct<XrVirtualKeyboardLocationInfoMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOCATIONTYPE;
    public static final int SPACE;
    public static final int POSEINSPACE;
    public static final int SCALE;

    protected XrVirtualKeyboardLocationInfoMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrVirtualKeyboardLocationInfoMETA create(long address, @Nullable ByteBuffer container) {
        return new XrVirtualKeyboardLocationInfoMETA(address, container);
    }

    public XrVirtualKeyboardLocationInfoMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVirtualKeyboardLocationInfoMETA.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVirtualKeyboardLocationInfoMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrVirtualKeyboardLocationInfoMETA.nnext(this.address());
    }

    @NativeType(value="XrVirtualKeyboardLocationTypeMETA")
    public int locationType() {
        return XrVirtualKeyboardLocationInfoMETA.nlocationType(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrVirtualKeyboardLocationInfoMETA.nspace(this.address());
    }

    public XrPosef poseInSpace() {
        return XrVirtualKeyboardLocationInfoMETA.nposeInSpace(this.address());
    }

    public float scale() {
        return XrVirtualKeyboardLocationInfoMETA.nscale(this.address());
    }

    public XrVirtualKeyboardLocationInfoMETA type(@NativeType(value="XrStructureType") int value) {
        XrVirtualKeyboardLocationInfoMETA.ntype(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardLocationInfoMETA type$Default() {
        return this.type(1000219004);
    }

    public XrVirtualKeyboardLocationInfoMETA next(@NativeType(value="void const *") long value) {
        XrVirtualKeyboardLocationInfoMETA.nnext(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardLocationInfoMETA locationType(@NativeType(value="XrVirtualKeyboardLocationTypeMETA") int value) {
        XrVirtualKeyboardLocationInfoMETA.nlocationType(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardLocationInfoMETA space(XrSpace value) {
        XrVirtualKeyboardLocationInfoMETA.nspace(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardLocationInfoMETA poseInSpace(XrPosef value) {
        XrVirtualKeyboardLocationInfoMETA.nposeInSpace(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardLocationInfoMETA poseInSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInSpace());
        return this;
    }

    public XrVirtualKeyboardLocationInfoMETA scale(float value) {
        XrVirtualKeyboardLocationInfoMETA.nscale(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardLocationInfoMETA set(int type, long next, int locationType, XrSpace space, XrPosef poseInSpace, float scale) {
        this.type(type);
        this.next(next);
        this.locationType(locationType);
        this.space(space);
        this.poseInSpace(poseInSpace);
        this.scale(scale);
        return this;
    }

    public XrVirtualKeyboardLocationInfoMETA set(XrVirtualKeyboardLocationInfoMETA src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVirtualKeyboardLocationInfoMETA malloc() {
        return new XrVirtualKeyboardLocationInfoMETA(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrVirtualKeyboardLocationInfoMETA calloc() {
        return new XrVirtualKeyboardLocationInfoMETA(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrVirtualKeyboardLocationInfoMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrVirtualKeyboardLocationInfoMETA(MemoryUtil.memAddress(container), container);
    }

    public static XrVirtualKeyboardLocationInfoMETA create(long address) {
        return new XrVirtualKeyboardLocationInfoMETA(address, null);
    }

    public static @Nullable XrVirtualKeyboardLocationInfoMETA createSafe(long address) {
        return address == 0L ? null : new XrVirtualKeyboardLocationInfoMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrVirtualKeyboardLocationInfoMETA.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVirtualKeyboardLocationInfoMETA.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVirtualKeyboardLocationInfoMETA malloc(MemoryStack stack) {
        return new XrVirtualKeyboardLocationInfoMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVirtualKeyboardLocationInfoMETA calloc(MemoryStack stack) {
        return new XrVirtualKeyboardLocationInfoMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nlocationType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOCATIONTYPE);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static XrPosef nposeInSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINSPACE);
    }

    public static float nscale(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)SCALE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlocationType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOCATIONTYPE, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void nposeInSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINSPACE, XrPosef.SIZEOF);
    }

    public static void nscale(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)SCALE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
    }

    static {
        Struct.Layout layout = XrVirtualKeyboardLocationInfoMETA.__struct(XrVirtualKeyboardLocationInfoMETA.__member(4), XrVirtualKeyboardLocationInfoMETA.__member(POINTER_SIZE), XrVirtualKeyboardLocationInfoMETA.__member(4), XrVirtualKeyboardLocationInfoMETA.__member(POINTER_SIZE), XrVirtualKeyboardLocationInfoMETA.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrVirtualKeyboardLocationInfoMETA.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOCATIONTYPE = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        POSEINSPACE = layout.offsetof(4);
        SCALE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrVirtualKeyboardLocationInfoMETA, Buffer>
    implements NativeResource {
        private static final XrVirtualKeyboardLocationInfoMETA ELEMENT_FACTORY = XrVirtualKeyboardLocationInfoMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrVirtualKeyboardLocationInfoMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVirtualKeyboardLocationInfoMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrVirtualKeyboardLocationInfoMETA.nnext(this.address());
        }

        @NativeType(value="XrVirtualKeyboardLocationTypeMETA")
        public int locationType() {
            return XrVirtualKeyboardLocationInfoMETA.nlocationType(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrVirtualKeyboardLocationInfoMETA.nspace(this.address());
        }

        public XrPosef poseInSpace() {
            return XrVirtualKeyboardLocationInfoMETA.nposeInSpace(this.address());
        }

        public float scale() {
            return XrVirtualKeyboardLocationInfoMETA.nscale(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVirtualKeyboardLocationInfoMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000219004);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrVirtualKeyboardLocationInfoMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer locationType(@NativeType(value="XrVirtualKeyboardLocationTypeMETA") int value) {
            XrVirtualKeyboardLocationInfoMETA.nlocationType(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrVirtualKeyboardLocationInfoMETA.nspace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(XrPosef value) {
            XrVirtualKeyboardLocationInfoMETA.nposeInSpace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInSpace());
            return this;
        }

        public Buffer scale(float value) {
            XrVirtualKeyboardLocationInfoMETA.nscale(this.address(), value);
            return this;
        }
    }
}

