/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVirtualKeyboardSpaceCreateInfoMETA
extends Struct<XrVirtualKeyboardSpaceCreateInfoMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOCATIONTYPE;
    public static final int SPACE;
    public static final int POSEINSPACE;

    protected XrVirtualKeyboardSpaceCreateInfoMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrVirtualKeyboardSpaceCreateInfoMETA create(long address, @Nullable ByteBuffer container) {
        return new XrVirtualKeyboardSpaceCreateInfoMETA(address, container);
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVirtualKeyboardSpaceCreateInfoMETA.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVirtualKeyboardSpaceCreateInfoMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrVirtualKeyboardSpaceCreateInfoMETA.nnext(this.address());
    }

    @NativeType(value="XrVirtualKeyboardLocationTypeMETA")
    public int locationType() {
        return XrVirtualKeyboardSpaceCreateInfoMETA.nlocationType(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrVirtualKeyboardSpaceCreateInfoMETA.nspace(this.address());
    }

    public XrPosef poseInSpace() {
        return XrVirtualKeyboardSpaceCreateInfoMETA.nposeInSpace(this.address());
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA type(@NativeType(value="XrStructureType") int value) {
        XrVirtualKeyboardSpaceCreateInfoMETA.ntype(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA type$Default() {
        return this.type(1000219003);
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA next(@NativeType(value="void const *") long value) {
        XrVirtualKeyboardSpaceCreateInfoMETA.nnext(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA locationType(@NativeType(value="XrVirtualKeyboardLocationTypeMETA") int value) {
        XrVirtualKeyboardSpaceCreateInfoMETA.nlocationType(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA space(XrSpace value) {
        XrVirtualKeyboardSpaceCreateInfoMETA.nspace(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA poseInSpace(XrPosef value) {
        XrVirtualKeyboardSpaceCreateInfoMETA.nposeInSpace(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA poseInSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInSpace());
        return this;
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA set(int type, long next, int locationType, XrSpace space, XrPosef poseInSpace) {
        this.type(type);
        this.next(next);
        this.locationType(locationType);
        this.space(space);
        this.poseInSpace(poseInSpace);
        return this;
    }

    public XrVirtualKeyboardSpaceCreateInfoMETA set(XrVirtualKeyboardSpaceCreateInfoMETA src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVirtualKeyboardSpaceCreateInfoMETA malloc() {
        return new XrVirtualKeyboardSpaceCreateInfoMETA(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrVirtualKeyboardSpaceCreateInfoMETA calloc() {
        return new XrVirtualKeyboardSpaceCreateInfoMETA(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrVirtualKeyboardSpaceCreateInfoMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrVirtualKeyboardSpaceCreateInfoMETA(MemoryUtil.memAddress(container), container);
    }

    public static XrVirtualKeyboardSpaceCreateInfoMETA create(long address) {
        return new XrVirtualKeyboardSpaceCreateInfoMETA(address, null);
    }

    public static @Nullable XrVirtualKeyboardSpaceCreateInfoMETA createSafe(long address) {
        return address == 0L ? null : new XrVirtualKeyboardSpaceCreateInfoMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrVirtualKeyboardSpaceCreateInfoMETA.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVirtualKeyboardSpaceCreateInfoMETA.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVirtualKeyboardSpaceCreateInfoMETA malloc(MemoryStack stack) {
        return new XrVirtualKeyboardSpaceCreateInfoMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVirtualKeyboardSpaceCreateInfoMETA calloc(MemoryStack stack) {
        return new XrVirtualKeyboardSpaceCreateInfoMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nlocationType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOCATIONTYPE);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static XrPosef nposeInSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINSPACE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlocationType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOCATIONTYPE, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void nposeInSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINSPACE, XrPosef.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
    }

    static {
        Struct.Layout layout = XrVirtualKeyboardSpaceCreateInfoMETA.__struct(XrVirtualKeyboardSpaceCreateInfoMETA.__member(4), XrVirtualKeyboardSpaceCreateInfoMETA.__member(POINTER_SIZE), XrVirtualKeyboardSpaceCreateInfoMETA.__member(4), XrVirtualKeyboardSpaceCreateInfoMETA.__member(POINTER_SIZE), XrVirtualKeyboardSpaceCreateInfoMETA.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOCATIONTYPE = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        POSEINSPACE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrVirtualKeyboardSpaceCreateInfoMETA, Buffer>
    implements NativeResource {
        private static final XrVirtualKeyboardSpaceCreateInfoMETA ELEMENT_FACTORY = XrVirtualKeyboardSpaceCreateInfoMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrVirtualKeyboardSpaceCreateInfoMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVirtualKeyboardSpaceCreateInfoMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrVirtualKeyboardSpaceCreateInfoMETA.nnext(this.address());
        }

        @NativeType(value="XrVirtualKeyboardLocationTypeMETA")
        public int locationType() {
            return XrVirtualKeyboardSpaceCreateInfoMETA.nlocationType(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrVirtualKeyboardSpaceCreateInfoMETA.nspace(this.address());
        }

        public XrPosef poseInSpace() {
            return XrVirtualKeyboardSpaceCreateInfoMETA.nposeInSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVirtualKeyboardSpaceCreateInfoMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000219003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrVirtualKeyboardSpaceCreateInfoMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer locationType(@NativeType(value="XrVirtualKeyboardLocationTypeMETA") int value) {
            XrVirtualKeyboardSpaceCreateInfoMETA.nlocationType(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrVirtualKeyboardSpaceCreateInfoMETA.nspace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(XrPosef value) {
            XrVirtualKeyboardSpaceCreateInfoMETA.nposeInSpace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInSpace());
            return this;
        }
    }
}

