/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVulkanSwapchainCreateInfoMETA
extends Struct<XrVulkanSwapchainCreateInfoMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ADDITIONALCREATEFLAGS;
    public static final int ADDITIONALUSAGEFLAGS;

    protected XrVulkanSwapchainCreateInfoMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrVulkanSwapchainCreateInfoMETA create(long address, @Nullable ByteBuffer container) {
        return new XrVulkanSwapchainCreateInfoMETA(address, container);
    }

    public XrVulkanSwapchainCreateInfoMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVulkanSwapchainCreateInfoMETA.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVulkanSwapchainCreateInfoMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrVulkanSwapchainCreateInfoMETA.nnext(this.address());
    }

    @NativeType(value="VkImageCreateFlags")
    public int additionalCreateFlags() {
        return XrVulkanSwapchainCreateInfoMETA.nadditionalCreateFlags(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int additionalUsageFlags() {
        return XrVulkanSwapchainCreateInfoMETA.nadditionalUsageFlags(this.address());
    }

    public XrVulkanSwapchainCreateInfoMETA type(@NativeType(value="XrStructureType") int value) {
        XrVulkanSwapchainCreateInfoMETA.ntype(this.address(), value);
        return this;
    }

    public XrVulkanSwapchainCreateInfoMETA type$Default() {
        return this.type(1000227000);
    }

    public XrVulkanSwapchainCreateInfoMETA next(@NativeType(value="void const *") long value) {
        XrVulkanSwapchainCreateInfoMETA.nnext(this.address(), value);
        return this;
    }

    public XrVulkanSwapchainCreateInfoMETA additionalCreateFlags(@NativeType(value="VkImageCreateFlags") int value) {
        XrVulkanSwapchainCreateInfoMETA.nadditionalCreateFlags(this.address(), value);
        return this;
    }

    public XrVulkanSwapchainCreateInfoMETA additionalUsageFlags(@NativeType(value="VkImageUsageFlags") int value) {
        XrVulkanSwapchainCreateInfoMETA.nadditionalUsageFlags(this.address(), value);
        return this;
    }

    public XrVulkanSwapchainCreateInfoMETA set(int type, long next, int additionalCreateFlags, int additionalUsageFlags) {
        this.type(type);
        this.next(next);
        this.additionalCreateFlags(additionalCreateFlags);
        this.additionalUsageFlags(additionalUsageFlags);
        return this;
    }

    public XrVulkanSwapchainCreateInfoMETA set(XrVulkanSwapchainCreateInfoMETA src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVulkanSwapchainCreateInfoMETA malloc() {
        return new XrVulkanSwapchainCreateInfoMETA(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrVulkanSwapchainCreateInfoMETA calloc() {
        return new XrVulkanSwapchainCreateInfoMETA(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrVulkanSwapchainCreateInfoMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrVulkanSwapchainCreateInfoMETA(MemoryUtil.memAddress(container), container);
    }

    public static XrVulkanSwapchainCreateInfoMETA create(long address) {
        return new XrVulkanSwapchainCreateInfoMETA(address, null);
    }

    public static @Nullable XrVulkanSwapchainCreateInfoMETA createSafe(long address) {
        return address == 0L ? null : new XrVulkanSwapchainCreateInfoMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrVulkanSwapchainCreateInfoMETA.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVulkanSwapchainCreateInfoMETA.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVulkanSwapchainCreateInfoMETA malloc(MemoryStack stack) {
        return new XrVulkanSwapchainCreateInfoMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVulkanSwapchainCreateInfoMETA calloc(MemoryStack stack) {
        return new XrVulkanSwapchainCreateInfoMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nadditionalCreateFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ADDITIONALCREATEFLAGS);
    }

    public static int nadditionalUsageFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ADDITIONALUSAGEFLAGS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nadditionalCreateFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ADDITIONALCREATEFLAGS, value);
    }

    public static void nadditionalUsageFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ADDITIONALUSAGEFLAGS, value);
    }

    static {
        Struct.Layout layout = XrVulkanSwapchainCreateInfoMETA.__struct(XrVulkanSwapchainCreateInfoMETA.__member(4), XrVulkanSwapchainCreateInfoMETA.__member(POINTER_SIZE), XrVulkanSwapchainCreateInfoMETA.__member(4), XrVulkanSwapchainCreateInfoMETA.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ADDITIONALCREATEFLAGS = layout.offsetof(2);
        ADDITIONALUSAGEFLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrVulkanSwapchainCreateInfoMETA, Buffer>
    implements NativeResource {
        private static final XrVulkanSwapchainCreateInfoMETA ELEMENT_FACTORY = XrVulkanSwapchainCreateInfoMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrVulkanSwapchainCreateInfoMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVulkanSwapchainCreateInfoMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrVulkanSwapchainCreateInfoMETA.nnext(this.address());
        }

        @NativeType(value="VkImageCreateFlags")
        public int additionalCreateFlags() {
            return XrVulkanSwapchainCreateInfoMETA.nadditionalCreateFlags(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int additionalUsageFlags() {
            return XrVulkanSwapchainCreateInfoMETA.nadditionalUsageFlags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVulkanSwapchainCreateInfoMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000227000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrVulkanSwapchainCreateInfoMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer additionalCreateFlags(@NativeType(value="VkImageCreateFlags") int value) {
            XrVulkanSwapchainCreateInfoMETA.nadditionalCreateFlags(this.address(), value);
            return this;
        }

        public Buffer additionalUsageFlags(@NativeType(value="VkImageUsageFlags") int value) {
            XrVulkanSwapchainCreateInfoMETA.nadditionalUsageFlags(this.address(), value);
            return this;
        }
    }
}

