/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshBlockML
extends Struct<XrWorldMeshBlockML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int UUID;
    public static final int BLOCKRESULT;
    public static final int LOD;
    public static final int FLAGS;
    public static final int INDEXCOUNT;
    public static final int INDEXBUFFER;
    public static final int VERTEXCOUNT;
    public static final int VERTEXBUFFER;
    public static final int NORMALCOUNT;
    public static final int NORMALBUFFER;
    public static final int CONFIDENCECOUNT;
    public static final int CONFIDENCEBUFFER;

    protected XrWorldMeshBlockML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrWorldMeshBlockML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshBlockML(address, container);
    }

    public XrWorldMeshBlockML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrWorldMeshBlockML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshBlockML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrWorldMeshBlockML.nnext(this.address());
    }

    public XrUuidEXT uuid() {
        return XrWorldMeshBlockML.nuuid(this.address());
    }

    @NativeType(value="XrWorldMeshBlockResultML")
    public int blockResult() {
        return XrWorldMeshBlockML.nblockResult(this.address());
    }

    @NativeType(value="XrWorldMeshDetectorLodML")
    public int lod() {
        return XrWorldMeshBlockML.nlod(this.address());
    }

    @NativeType(value="XrWorldMeshDetectorFlagsML")
    public long flags() {
        return XrWorldMeshBlockML.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCount() {
        return XrWorldMeshBlockML.nindexCount(this.address());
    }

    @NativeType(value="uint16_t *")
    public ShortBuffer indexBuffer() {
        return XrWorldMeshBlockML.nindexBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCount() {
        return XrWorldMeshBlockML.nvertexCount(this.address());
    }

    @NativeType(value="XrVector3f *")
    public XrVector3f.Buffer vertexBuffer() {
        return XrWorldMeshBlockML.nvertexBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int normalCount() {
        return XrWorldMeshBlockML.nnormalCount(this.address());
    }

    @NativeType(value="XrVector3f *")
    public XrVector3f.Buffer normalBuffer() {
        return XrWorldMeshBlockML.nnormalBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int confidenceCount() {
        return XrWorldMeshBlockML.nconfidenceCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer confidenceBuffer() {
        return XrWorldMeshBlockML.nconfidenceBuffer(this.address());
    }

    public XrWorldMeshBlockML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshBlockML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML type$Default() {
        return this.type(1000474010);
    }

    public XrWorldMeshBlockML next(@NativeType(value="void *") long value) {
        XrWorldMeshBlockML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML uuid(XrUuidEXT value) {
        XrWorldMeshBlockML.nuuid(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML uuid(Consumer<XrUuidEXT> consumer) {
        consumer.accept(this.uuid());
        return this;
    }

    public XrWorldMeshBlockML blockResult(@NativeType(value="XrWorldMeshBlockResultML") int value) {
        XrWorldMeshBlockML.nblockResult(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML lod(@NativeType(value="XrWorldMeshDetectorLodML") int value) {
        XrWorldMeshBlockML.nlod(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML flags(@NativeType(value="XrWorldMeshDetectorFlagsML") long value) {
        XrWorldMeshBlockML.nflags(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML indexBuffer(@NativeType(value="uint16_t *") ShortBuffer value) {
        XrWorldMeshBlockML.nindexBuffer(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML vertexBuffer(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
        XrWorldMeshBlockML.nvertexBuffer(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML normalBuffer(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
        XrWorldMeshBlockML.nnormalBuffer(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML confidenceBuffer(@NativeType(value="float *") FloatBuffer value) {
        XrWorldMeshBlockML.nconfidenceBuffer(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML set(int type, long next, XrUuidEXT uuid, int blockResult, int lod, long flags, ShortBuffer indexBuffer, XrVector3f.Buffer vertexBuffer, XrVector3f.Buffer normalBuffer, FloatBuffer confidenceBuffer) {
        this.type(type);
        this.next(next);
        this.uuid(uuid);
        this.blockResult(blockResult);
        this.lod(lod);
        this.flags(flags);
        this.indexBuffer(indexBuffer);
        this.vertexBuffer(vertexBuffer);
        this.normalBuffer(normalBuffer);
        this.confidenceBuffer(confidenceBuffer);
        return this;
    }

    public XrWorldMeshBlockML set(XrWorldMeshBlockML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrWorldMeshBlockML malloc() {
        return new XrWorldMeshBlockML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrWorldMeshBlockML calloc() {
        return new XrWorldMeshBlockML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrWorldMeshBlockML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrWorldMeshBlockML(MemoryUtil.memAddress(container), container);
    }

    public static XrWorldMeshBlockML create(long address) {
        return new XrWorldMeshBlockML(address, null);
    }

    public static @Nullable XrWorldMeshBlockML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshBlockML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrWorldMeshBlockML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshBlockML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshBlockML malloc(MemoryStack stack) {
        return new XrWorldMeshBlockML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshBlockML calloc(MemoryStack stack) {
        return new XrWorldMeshBlockML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static XrUuidEXT nuuid(long struct) {
        return XrUuidEXT.create(struct + (long)UUID);
    }

    public static int nblockResult(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKRESULT);
    }

    public static int nlod(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOD);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLAGS);
    }

    public static int nindexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEXCOUNT);
    }

    public static ShortBuffer nindexBuffer(long struct) {
        return MemoryUtil.memShortBuffer(MemoryUtil.memGetAddress(struct + (long)INDEXBUFFER), XrWorldMeshBlockML.nindexCount(struct));
    }

    public static int nvertexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXCOUNT);
    }

    public static XrVector3f.Buffer nvertexBuffer(long struct) {
        return XrVector3f.create(MemoryUtil.memGetAddress(struct + (long)VERTEXBUFFER), XrWorldMeshBlockML.nvertexCount(struct));
    }

    public static int nnormalCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NORMALCOUNT);
    }

    public static XrVector3f.Buffer nnormalBuffer(long struct) {
        return XrVector3f.create(MemoryUtil.memGetAddress(struct + (long)NORMALBUFFER), XrWorldMeshBlockML.nnormalCount(struct));
    }

    public static int nconfidenceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONFIDENCECOUNT);
    }

    public static FloatBuffer nconfidenceBuffer(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)CONFIDENCEBUFFER), XrWorldMeshBlockML.nconfidenceCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nuuid(long struct, XrUuidEXT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)UUID, XrUuidEXT.SIZEOF);
    }

    public static void nblockResult(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKRESULT, value);
    }

    public static void nlod(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOD, value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FLAGS, value);
    }

    public static void nindexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDEXCOUNT, value);
    }

    public static void nindexBuffer(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDEXBUFFER, MemoryUtil.memAddress(value));
        XrWorldMeshBlockML.nindexCount(struct, value.remaining());
    }

    public static void nvertexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXCOUNT, value);
    }

    public static void nvertexBuffer(long struct, XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXBUFFER, value.address());
        XrWorldMeshBlockML.nvertexCount(struct, value.remaining());
    }

    public static void nnormalCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NORMALCOUNT, value);
    }

    public static void nnormalBuffer(long struct, XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)NORMALBUFFER, value.address());
        XrWorldMeshBlockML.nnormalCount(struct, value.remaining());
    }

    public static void nconfidenceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONFIDENCECOUNT, value);
    }

    public static void nconfidenceBuffer(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)CONFIDENCEBUFFER, MemoryUtil.memAddress(value));
        XrWorldMeshBlockML.nconfidenceCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INDEXBUFFER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTEXBUFFER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NORMALBUFFER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CONFIDENCEBUFFER));
    }

    static {
        Struct.Layout layout = XrWorldMeshBlockML.__struct(XrWorldMeshBlockML.__member(4), XrWorldMeshBlockML.__member(POINTER_SIZE), XrWorldMeshBlockML.__member(XrUuidEXT.SIZEOF, XrUuidEXT.ALIGNOF), XrWorldMeshBlockML.__member(4), XrWorldMeshBlockML.__member(4), XrWorldMeshBlockML.__member(8), XrWorldMeshBlockML.__member(4), XrWorldMeshBlockML.__member(POINTER_SIZE), XrWorldMeshBlockML.__member(4), XrWorldMeshBlockML.__member(POINTER_SIZE), XrWorldMeshBlockML.__member(4), XrWorldMeshBlockML.__member(POINTER_SIZE), XrWorldMeshBlockML.__member(4), XrWorldMeshBlockML.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        UUID = layout.offsetof(2);
        BLOCKRESULT = layout.offsetof(3);
        LOD = layout.offsetof(4);
        FLAGS = layout.offsetof(5);
        INDEXCOUNT = layout.offsetof(6);
        INDEXBUFFER = layout.offsetof(7);
        VERTEXCOUNT = layout.offsetof(8);
        VERTEXBUFFER = layout.offsetof(9);
        NORMALCOUNT = layout.offsetof(10);
        NORMALBUFFER = layout.offsetof(11);
        CONFIDENCECOUNT = layout.offsetof(12);
        CONFIDENCEBUFFER = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshBlockML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshBlockML ELEMENT_FACTORY = XrWorldMeshBlockML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrWorldMeshBlockML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshBlockML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrWorldMeshBlockML.nnext(this.address());
        }

        public XrUuidEXT uuid() {
            return XrWorldMeshBlockML.nuuid(this.address());
        }

        @NativeType(value="XrWorldMeshBlockResultML")
        public int blockResult() {
            return XrWorldMeshBlockML.nblockResult(this.address());
        }

        @NativeType(value="XrWorldMeshDetectorLodML")
        public int lod() {
            return XrWorldMeshBlockML.nlod(this.address());
        }

        @NativeType(value="XrWorldMeshDetectorFlagsML")
        public long flags() {
            return XrWorldMeshBlockML.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCount() {
            return XrWorldMeshBlockML.nindexCount(this.address());
        }

        @NativeType(value="uint16_t *")
        public ShortBuffer indexBuffer() {
            return XrWorldMeshBlockML.nindexBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCount() {
            return XrWorldMeshBlockML.nvertexCount(this.address());
        }

        @NativeType(value="XrVector3f *")
        public XrVector3f.Buffer vertexBuffer() {
            return XrWorldMeshBlockML.nvertexBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int normalCount() {
            return XrWorldMeshBlockML.nnormalCount(this.address());
        }

        @NativeType(value="XrVector3f *")
        public XrVector3f.Buffer normalBuffer() {
            return XrWorldMeshBlockML.nnormalBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int confidenceCount() {
            return XrWorldMeshBlockML.nconfidenceCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer confidenceBuffer() {
            return XrWorldMeshBlockML.nconfidenceBuffer(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshBlockML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474010);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrWorldMeshBlockML.nnext(this.address(), value);
            return this;
        }

        public Buffer uuid(XrUuidEXT value) {
            XrWorldMeshBlockML.nuuid(this.address(), value);
            return this;
        }

        public Buffer uuid(Consumer<XrUuidEXT> consumer) {
            consumer.accept(this.uuid());
            return this;
        }

        public Buffer blockResult(@NativeType(value="XrWorldMeshBlockResultML") int value) {
            XrWorldMeshBlockML.nblockResult(this.address(), value);
            return this;
        }

        public Buffer lod(@NativeType(value="XrWorldMeshDetectorLodML") int value) {
            XrWorldMeshBlockML.nlod(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrWorldMeshDetectorFlagsML") long value) {
            XrWorldMeshBlockML.nflags(this.address(), value);
            return this;
        }

        public Buffer indexBuffer(@NativeType(value="uint16_t *") ShortBuffer value) {
            XrWorldMeshBlockML.nindexBuffer(this.address(), value);
            return this;
        }

        public Buffer vertexBuffer(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
            XrWorldMeshBlockML.nvertexBuffer(this.address(), value);
            return this;
        }

        public Buffer normalBuffer(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
            XrWorldMeshBlockML.nnormalBuffer(this.address(), value);
            return this;
        }

        public Buffer confidenceBuffer(@NativeType(value="float *") FloatBuffer value) {
            XrWorldMeshBlockML.nconfidenceBuffer(this.address(), value);
            return this;
        }
    }
}

