/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent3DfEXT;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshStateRequestInfoML
extends Struct<XrWorldMeshStateRequestInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int BOUNDINGBOXCENTER;
    public static final int BOUNDINGBOXEXTENTS;

    protected XrWorldMeshStateRequestInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrWorldMeshStateRequestInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshStateRequestInfoML(address, container);
    }

    public XrWorldMeshStateRequestInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrWorldMeshStateRequestInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshStateRequestInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrWorldMeshStateRequestInfoML.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrWorldMeshStateRequestInfoML.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrWorldMeshStateRequestInfoML.ntime(this.address());
    }

    public XrPosef boundingBoxCenter() {
        return XrWorldMeshStateRequestInfoML.nboundingBoxCenter(this.address());
    }

    public XrExtent3DfEXT boundingBoxExtents() {
        return XrWorldMeshStateRequestInfoML.nboundingBoxExtents(this.address());
    }

    public XrWorldMeshStateRequestInfoML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshStateRequestInfoML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML type$Default() {
        return this.type(1000474002);
    }

    public XrWorldMeshStateRequestInfoML next(@NativeType(value="void const *") long value) {
        XrWorldMeshStateRequestInfoML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML baseSpace(XrSpace value) {
        XrWorldMeshStateRequestInfoML.nbaseSpace(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML time(@NativeType(value="XrTime") long value) {
        XrWorldMeshStateRequestInfoML.ntime(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML boundingBoxCenter(XrPosef value) {
        XrWorldMeshStateRequestInfoML.nboundingBoxCenter(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML boundingBoxCenter(Consumer<XrPosef> consumer) {
        consumer.accept(this.boundingBoxCenter());
        return this;
    }

    public XrWorldMeshStateRequestInfoML boundingBoxExtents(XrExtent3DfEXT value) {
        XrWorldMeshStateRequestInfoML.nboundingBoxExtents(this.address(), value);
        return this;
    }

    public XrWorldMeshStateRequestInfoML boundingBoxExtents(Consumer<XrExtent3DfEXT> consumer) {
        consumer.accept(this.boundingBoxExtents());
        return this;
    }

    public XrWorldMeshStateRequestInfoML set(int type, long next, XrSpace baseSpace, long time, XrPosef boundingBoxCenter, XrExtent3DfEXT boundingBoxExtents) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.boundingBoxCenter(boundingBoxCenter);
        this.boundingBoxExtents(boundingBoxExtents);
        return this;
    }

    public XrWorldMeshStateRequestInfoML set(XrWorldMeshStateRequestInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrWorldMeshStateRequestInfoML malloc() {
        return new XrWorldMeshStateRequestInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrWorldMeshStateRequestInfoML calloc() {
        return new XrWorldMeshStateRequestInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrWorldMeshStateRequestInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrWorldMeshStateRequestInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrWorldMeshStateRequestInfoML create(long address) {
        return new XrWorldMeshStateRequestInfoML(address, null);
    }

    public static @Nullable XrWorldMeshStateRequestInfoML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshStateRequestInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrWorldMeshStateRequestInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshStateRequestInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshStateRequestInfoML malloc(MemoryStack stack) {
        return new XrWorldMeshStateRequestInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshStateRequestInfoML calloc(MemoryStack stack) {
        return new XrWorldMeshStateRequestInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BASESPACE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static XrPosef nboundingBoxCenter(long struct) {
        return XrPosef.create(struct + (long)BOUNDINGBOXCENTER);
    }

    public static XrExtent3DfEXT nboundingBoxExtents(long struct) {
        return XrExtent3DfEXT.create(struct + (long)BOUNDINGBOXEXTENTS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)BASESPACE, value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void nboundingBoxCenter(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BOUNDINGBOXCENTER, XrPosef.SIZEOF);
    }

    public static void nboundingBoxExtents(long struct, XrExtent3DfEXT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BOUNDINGBOXEXTENTS, XrExtent3DfEXT.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BASESPACE));
    }

    static {
        Struct.Layout layout = XrWorldMeshStateRequestInfoML.__struct(XrWorldMeshStateRequestInfoML.__member(4), XrWorldMeshStateRequestInfoML.__member(POINTER_SIZE), XrWorldMeshStateRequestInfoML.__member(POINTER_SIZE), XrWorldMeshStateRequestInfoML.__member(8), XrWorldMeshStateRequestInfoML.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrWorldMeshStateRequestInfoML.__member(XrExtent3DfEXT.SIZEOF, XrExtent3DfEXT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
        BOUNDINGBOXCENTER = layout.offsetof(4);
        BOUNDINGBOXEXTENTS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshStateRequestInfoML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshStateRequestInfoML ELEMENT_FACTORY = XrWorldMeshStateRequestInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrWorldMeshStateRequestInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshStateRequestInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrWorldMeshStateRequestInfoML.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrWorldMeshStateRequestInfoML.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrWorldMeshStateRequestInfoML.ntime(this.address());
        }

        public XrPosef boundingBoxCenter() {
            return XrWorldMeshStateRequestInfoML.nboundingBoxCenter(this.address());
        }

        public XrExtent3DfEXT boundingBoxExtents() {
            return XrWorldMeshStateRequestInfoML.nboundingBoxExtents(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshStateRequestInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrWorldMeshStateRequestInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrWorldMeshStateRequestInfoML.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrWorldMeshStateRequestInfoML.ntime(this.address(), value);
            return this;
        }

        public Buffer boundingBoxCenter(XrPosef value) {
            XrWorldMeshStateRequestInfoML.nboundingBoxCenter(this.address(), value);
            return this;
        }

        public Buffer boundingBoxCenter(Consumer<XrPosef> consumer) {
            consumer.accept(this.boundingBoxCenter());
            return this;
        }

        public Buffer boundingBoxExtents(XrExtent3DfEXT value) {
            XrWorldMeshStateRequestInfoML.nboundingBoxExtents(this.address(), value);
            return this;
        }

        public Buffer boundingBoxExtents(Consumer<XrExtent3DfEXT> consumer) {
            consumer.accept(this.boundingBoxExtents());
            return this;
        }
    }
}

